unit MainForm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls, FileCtrl,
  ExtCtrls, Tabs, DlphiDos, Buttons, Spin;

type
  TFrmMain = class(TForm)
    TabPages: TTabSet;
    NbkPages: TNotebook;
    EdtDate: TEdit;
    LstFiles: TFileListBox;
    EdtDir: TEdit;
    FraBorder: TBevel;
    EdtNumber: TEdit;
    LblNumber: TLabel;
    GrpFileInfo: TGroupBox;
    LblFilePath: TLabel;
    LblFileName: TLabel;
    PnlFilePath: TPanel;
    PnlFileName: TPanel;
    PnlFileExt: TPanel;
    PnlNewExt: TPanel;
    LblFileExt: TLabel;
    LblExtChg: TLabel;
    LblSelDir: TLabel;
    LblFiles: TLabel;
    BtnSet: TBitBtn;
    BtnSelect: TBitBtn;
    BtnBreak: TBitBtn;
    GrpSearchFiles: TGroupBox;
    LblSearch: TLabel;
    EdtSearchFor: TEdit;
    LblOnPath: TLabel;
    EdtSearchPath: TEdit;
    BtnDosPath: TBitBtn;
    GrpFindFiles: TGroupBox;
    BtnFormat: TBitBtn;
    GrpFormatResults: TGroupBox;
    PnlResult1: TPanel;
    PnlResult2: TPanel;
    PnlResult3: TPanel;
    PnlResult4: TPanel;
    PnlResult5: TPanel;
    LblResult1: TLabel;
    LblResult2: TLabel;
    LblResult3: TLabel;
    LblResult4: TLabel;
    LblResult5: TLabel;
    PnlNow: TPanel;
    BtnNow: TBitBtn;
    BtnDOW: TBitBtn;
    LblEnterDate: TLabel;
    GrpDOWResults: TGroupBox;
    GrpDayOfWeek: TRadioGroup;
    LblMonth: TLabel;
    LblDay: TLabel;
    LblYear: TLabel;
    PnlYear: TPanel;
    PnlDay: TPanel;
    PnlMonth: TPanel;
    SpnWidth: TSpinEdit;
    SpnDigits: TSpinEdit;
    LblWidth: TLabel;
    LblDigits: TLabel;
    BtnSearch: TBitBtn;
    PnlResult: TPanel;
    EdtFileMask: TEdit;
    LstFilesFound: TListBox;
    LblFileMask: TLabel;
    LblFilesFound: TLabel;
    BtnFind: TBitBtn;
    procedure BtnSelectClick(Sender: TObject);
    procedure TabPagesChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure BtnDOWClick(Sender: TObject);
    procedure BtnSetClick(Sender: TObject);
    procedure BtnBreakClick(Sender: TObject);
    procedure BtnDosPathClick(Sender: TObject);
    procedure BtnSearchClick(Sender: TObject);
    procedure BtnFormatClick(Sender: TObject);
    procedure BtnNowClick(Sender: TObject);
    procedure BtnFindClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmMain: TFrmMain;

implementation

{$R *.DFM}


procedure TFrmMain.TabPagesChange( Sender : TObject;
                                   NewTab : Integer;
                                   var AllowChange : Boolean);
begin
               { Change Notebook pages when new Tab is selected }
  NbkPages.PageIndex := NewTab;
end;

procedure TFrmMain.FormCreate(Sender: TObject);
begin
  TabPages.Tabs := NbkPages.Pages;   { Set Tab Names = to Pages }
  NbkPages.PageIndex := TabPages.TabIndex;
end;


{== File Management Methods ==}

procedure TFrmMain.BtnSetClick(Sender: TObject);
begin
  if DirectoryExists( EdtDir.Text ) then
    LstFiles.Directory := EdtDir.Text    { Update File List Box }
  else
    MessageDlg( 'Directory Does Not Exist', mtError, [ mbOK ], 0 );
end;

procedure TFrmMain.BtnSelectClick(Sender: TObject);
var
  Dir : string;
begin
  Dir := EdtDir.Text;
    { SelectDirectory starts off in the directory stored in Dir }
  if SelectDirectory( Dir,
     [ sdAllowCreate, sdPerformCreate, sdPrompt ], 0 ) then
  begin
    EdtDir.Text := Dir;   { Populate EdtDir Fld w/ Selected Dir }
    LstFiles.Directory := Dir;           { Update File List Box }
  end;
end;

procedure TFrmMain.BtnBreakClick(Sender: TObject);
var
  FileName : string;
begin
  FileName := LstFiles.Items.Strings[ LstFiles.ItemIndex ];
  { FileName := LstFiles.FileName;
      is more appropriate.  However, the file name returned is
      already expanded, and therefore doesn't lend itself well
      to showing the ExpandFileName fcn }

         { ExpandFileName also coverts the string to upper case }
  FileName := ExpandFileName( FileName );

  PnlFilePath.Caption := ExtractFilePath( FileName );
  PnlFileName.Caption := ExtractFileName( FileName );
  PnlFileExt.Caption  := ExtractFileExt( FileName );
  PnlNewExt.Caption := ChangeFileExt( PnlFileName.Caption, '.INI');
end;


{== File Searching Methods ==}

procedure TFrmMain.BtnDosPathClick(Sender: TObject);
begin
  EdtSearchPath.Text := GetEnvStr( 'PATH' );
end;

procedure TFrmMain.BtnSearchClick(Sender: TObject);
var
  S : string;
begin
                           { FileSearch uses strings not PChars }
  S := FileSearch( EdtSearchFor.Text, EdtSearchPath.Text );
  if S <> '' then
    PnlResult.Caption := S
  else
    PnlResult.Caption := 'Not Found';
end;

procedure TFrmMain.BtnFindClick(Sender: TObject);
var
  SearchRec : TSearchRec;
  RetVal    : Integer;
begin
  LstFilesFound.Clear;
  RetVal := FindFirst( EdtFileMask.Text, faAnyFile, SearchRec );
  while RetVal = 0 do                 { RetVal = 0 -> No Errors }
  begin               { SearchRec.Name holds matching file name }
    LstFilesFound.Items.Add( SearchRec.Name );
    RetVal := FindNext( SearchRec );
  end;
  FindClose( SearchRec );           { Needed when move to Win32 }
end;


{== Numeric Strings Methods ==}

procedure TFrmMain.BtnFormatClick(Sender: TObject);
var
  X : Real;
begin
  X := StrToFloat( EdtNumber.Text );

  PnlResult1.Caption := FloatToStrF( X, ffNumber, 10, 3 );
  PnlResult2.Caption := FloatToStrF( X, ffCurrency, 10, 2 );
  PnlResult3.Caption := FormatFloat( ',0.00;(,0.00);Zero', X );
  PnlResult4.Caption := Format( '%f at %p', [ X, @X ] );
  PnlResult5.Caption := Format( '%-*.*f',
    [ SpnWidth.Value, SpnDigits.Value, X ] );
end;


{== Date and Time Methods ==}

procedure TFrmMain.BtnNowClick(Sender: TObject);
begin
  PnlNow.Caption := DateTimeToStr( Now );
end;

procedure TFrmMain.BtnDOWClick(Sender: TObject);
var
  DT : TDateTime;
  Year, Month, Day : Word;
begin
  DT := StrToDateTime( EdtDate.Text );   { Get Date from string }
  DecodeDate( DT, Year, Month, Day );
  PnlMonth.Caption := IntToStr( Month );
  PnlDay.Caption := IntToStr( Day );
  PnlYear.Caption := IntToStr( Year );
                  { DayOfWeek = 1 for Sunday, 2 for Monday, ... }
  GrpDayOfWeek.ItemIndex := DayOfWeek( DT ) - 1;
end;

end.
