unit DlphiDos;

interface

  function GetEnvStr( VarName : string ) : string;

implementation

  uses
    WinProcs, SysUtils;

  {=============================================================}
  {= GetEnvStr - Get Dos Environment Variable Setting          =}
  {=                                                           =}
  {= This function is a modified version of the GetEnvVar      =}
  {= function that appears in the WinDos unit that comes       =}
  {= with Delphi.  This function's interface uses Pascal       =}
  {= strings instead of null-terminated strings.               =}
  {=============================================================}

  function GetEnvStr( VarName : string ) : string;
  var
    Len     : Word;
    EnvStz  : PChar;
    NameStz : array[ 0..180 ] of Char;
  begin
    StrPCopy( NameStz, VarName );     { Covert VarName to PChar }
    Len := StrLen( NameStz );
    EnvStz := GetDosEnvironment;      { EnvStz holds entire env }

    while EnvStz^ <> #0 do
    begin                  { Pick off Variable Name and Compare }
      if ( StrLIComp( EnvStz, NameStz, Len ) = 0 ) and
         ( EnvStz[ Len ] = '=' ) then
      begin          { Convert to Pascal string before returing }
        Result := StrPas( EnvStz + Len + 1 );
        Exit;
      end;
      Inc( EnvStz, StrLen( EnvStz ) + 1 );   { Jump to Next Var }
    end;
    Result := '';
  end;

end.
