/* Simple Logic Diagrammer  -- Williams */
#include <windows.h>
#include "logsim.h"
#include "dragsize.h"

HWND       hWnd;    /* Handle to main window */
HINSTANCE  hInst;   /* Handle to instance data*/

/* Forward ref */
int DrawBitmap(HANDLE hinst,HWND w,HDC dc,LPSTR bmp);
long CALLBACK _export GateProc(HWND w,UINT cmd,
  WPARAM wParam,LPARAM lParam);


int PASCAL WinMain(HINSTANCE hInstance,
  HINSTANCE hPrevInstance,LPSTR lpCmdLine,
  int nCmdShow)
  {
  MSG msg;

  if (!hPrevInstance)
    if (!InitApplication(hInstance))
       return (FALSE);

  if (!InitInstance(hInstance, nCmdShow))
       return (FALSE);

  while (GetMessage(&msg, NULL, NULL, NULL))
    {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }
  return (msg.wParam);
  }

/* Window offsets to store IC# and type */
#define ICNR 0
#define ICTYPE 4

BOOL InitApplication(HINSTANCE hInstance)
   {
/* Register gate window */
   WNDCLASS wc;
   wc.style = CS_HREDRAW|CS_VREDRAW;
   wc.lpfnWndProc = GateProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 8;
   wc.hInstance = hInstance;
   wc.hIcon = NULL;
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground= GetStockObject(WHITE_BRUSH);
   wc.lpszMenuName =NULL;
   wc.lpszClassName = "GateClass";
   if (!RegisterClass(&wc)) return FALSE;
/* Register main window */
   wc.style = NULL;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW+1;
   wc.lpszMenuName ="MainMenu";
   wc.lpszClassName = "LOGSIMClass";
   return (RegisterClass(&wc));
   }

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
   {
   hInst = hInstance;
/* Create main window */
   hWnd = CreateWindow(
       "LOGSIMClass",
       "Logic Simulator (incomplete)",
       WS_OVERLAPPEDWINDOW,
       CW_USEDEFAULT,
       CW_USEDEFAULT,
       CW_USEDEFAULT,
       CW_USEDEFAULT,
       NULL,
       NULL,
       hInstance,
       NULL
       );

   if (!hWnd)
       return (FALSE);

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);
   return (TRUE);
   }


/* Main window procedure */
LRESULT CALLBACK _export MainWndProc(HWND hWnd,
  UINT message, WPARAM wParam, LPARAM lParam)
   {
   switch (message)
     {
     case WM_PAINT:
       {
       HDC dc;
       PAINTSTRUCT ps;
       dc=BeginPaint(hWnd,&ps);
/* No painting to do here!
   -- eventually, you might paint
   interconnecting lines, etc. */
       EndPaint(hWnd,&ps);
       break;
       }

/* If button goes down here, deselect all windows */
    case WM_LBUTTONDOWN:
         unselect(FALSE);
         InvalidateRect(hWnd,NULL,FALSE);
         break;

     case WM_COMMAND:
           switch (wParam)
             {
             case IDM_NEW:
             case IDM_OPEN:
             case IDM_SAVE:
             case IDM_SAVEAS:
             case IDM_PRINT:
               MessageBox(hWnd,
                   "Command not implemented",
                   "Notice",
                   MB_OK);
                   break;

/* Delete a gate window */
             case IDM_DEL:
                  if (selected())
                    {
                    HWND w=selected();
                    unselect(TRUE);
                    DestroyWindow(w);
                    }
                  break;

/* add gates -- all gates are the same window, with
   a different type. AND=0, OR=1, NOT=2 */
             case AND:
                   add_gate(hWnd,0);
                   break;

             case OR:
                   add_gate(hWnd,1);
                   break;

             case NOT:
                   add_gate(hWnd,2);
                   break;

             case IDM_EXIT:
                   DestroyWindow(hWnd);
                   break;


             case IDM_ABOUT:
                   MessageBox(hWnd,
                      "Logic Simulator by Al Williams",
                      "About",MB_OK|MB_ICONEXCLAMATION);
                   break;

           }

         break;


       case WM_DESTROY:
           PostQuitMessage(0);
           break;

       default:
           return (DefWindowProc(hWnd, message,
             wParam, lParam));
       }
     return (NULL);
  }


/* Add a gate */
void add_gate(HWND w,int typ)
  {
  static int n=0;  /* Sequence # */
  HWND nw;
/* Make window with child ID==sequence # */
  nw=CreateWindow("GateClass",NULL,
    WS_THICKFRAME|WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS,
    0,0,100,50,w,(HMENU)++n,
    GetWindowWord(w,GWW_HINSTANCE),(LPSTR)typ);
/* Store IC Sequence # */
  SetWindowLong(nw,ICNR,n);
  select(nw,TRUE);
  }

/* Paint gate */
long PaintObj(HWND w)
  {
  PAINTSTRUCT ps;
  HDC dc;
  RECT r;
  HBRUSH br;
  int id=GetWindowLong(w,ICNR);
  char msg[65];
  GetClientRect(w,&r);
  dc=BeginPaint(w,&ps);
/* Draw proper gate */
  DrawBitmap(GetWindowWord(w,GWW_HINSTANCE),w,dc,
    (LPSTR)(BMP_BASE+GetWindowLong(w,ICTYPE)));
/* Draw centered title text */
  SetBkMode(dc,TRANSPARENT);
  wsprintf(msg,"IC  %d",id);
  SetTextColor(dc,RGB(0xFF,0xFF,0xFF));
  DrawText(dc,msg,-1,&r,
    DT_CENTER|DT_VCENTER|DT_SINGLELINE);
  EndPaint(w,&ps);
  return 0;
  }


long CALLBACK _export GateProc(HWND w,UINT cmd,
  WPARAM wParam,LPARAM lParam)
  {
  if (cmd==WM_CREATE)
    {
/* Store away gate type */
    LPCREATESTRUCT cs=(LPCREATESTRUCT)lParam;
    SetWindowLong(w,ICTYPE,(DWORD)cs->lpCreateParams);
    }
  else if (cmd==WM_PAINT)  /* Paint */
    return PaintObj(w);
/* Do drag/size default proc */
  return DefDSWindowProc(w,cmd,wParam,lParam);
  }

/* Draw a bitmap -- stretch to fit */
int DrawBitmap(HANDLE hinst,HWND w,HDC hdc,LPSTR bmp)
  {
  HDC  hdcMem;
  HBITMAP hbmp, hbmpOld;
  BITMAP bm;
  PAINTSTRUCT ps;
  RECT r;
  int rv;

  hbmp = LoadBitmap(hinst, bmp);
  GetObject(hbmp, sizeof(BITMAP), &bm);

  hdcMem = CreateCompatibleDC(hdc);
  hbmpOld = SelectObject(hdcMem, hbmp);
  GetClientRect(w,&r);
  rv=StretchBlt(hdc, 0, 0, r.right, r.bottom,
    hdcMem, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY);

  DeleteObject(SelectObject(hdcMem,hbmpOld));
  DeleteDC(hdcMem);
  return rv;
  }
