/* Editor demo -- Williams */
#include <windows.h>
#include "eddef.h"

/* Handle to main window */
HWND       hWnd;
/* Handle to instance data*/
HINSTANCE  hInst;

LRESULT CALLBACK MainWndProc();

int PASCAL WinMain(HINSTANCE hInstance,
  HINSTANCE hPrevInstance,LPSTR lpCmdLine,
  int nCmdShow)
  {
  MSG msg;
  if (!hPrevInstance)
    if (!InitApplication(hInstance))
       return (FALSE);
  if (!InitInstance(hInstance, nCmdShow))
       return (FALSE);
  while (GetMessage(&msg, 0, 0, 0))
    {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }
  return (msg.wParam);
  }

/* Register class */
BOOL InitApplication(HINSTANCE hInstance)
   {
   WNDCLASS wc;
   wc.style = 0;
   wc.lpfnWndProc = (WNDPROC)MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(hInstance, "ICON1");
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE+1);
   wc.lpszMenuName = NULL;
   wc.lpszClassName = "EDCLASS";
   return (RegisterClass(&wc));
   }

/* Create window */
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
   {
   hInst = hInstance;
   hWnd = CreateWindow(
       "EDCLASS",
       "Editor demo",
       WS_OVERLAPPEDWINDOW,
       CW_USEDEFAULT,CW_USEDEFAULT,
       CW_USEDEFAULT,CW_USEDEFAULT,
       NULL,NULL,hInstance,
       (LPSTR)(WS_VSCROLL|WS_HSCROLL|
         ES_AUTOVSCROLL|ES_AUTOHSCROLL));
   if (!hWnd)
       return (FALSE);
   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);
   return (TRUE);
   }

LRESULT CALLBACK  MainWndProc(HWND hWnd,
  UINT message, WPARAM wParam, LPARAM lParam)
   {
/* Let default do all the work */
   return (DefEditProc(hWnd, message,
             wParam, lParam));
   }


