/* Editor default window procedure -- Williams */
#include <windows.h>

/* Property to store edit control handle */
static char eprop[]="EDIT";

#define GETEDITCTL(w) GetProp(w,eprop)

LONG WINAPI _export DefEditProc(HWND w,UINT msg,
  UINT wParam, LONG lParam)
  {
  switch (msg)
    {
    HWND editctl;
    case WM_CREATE:
      {
      LPCREATESTRUCT cs=(LPCREATESTRUCT)lParam;
      RECT r;
      GetClientRect(w,&r);
/* Create child edit control */
      editctl=CreateWindow("EDIT","",
        ES_MULTILINE|WS_CHILD|WS_VISIBLE|
        (DWORD)(cs->lpCreateParams),
        0,0,r.right,r.bottom,w,NULL,
        cs->hInstance,NULL);
/* Save handle */
      SetProp(w,eprop,editctl);
      }
      break;

/* Prompt before exit if editor dirty */
    case WM_QUERYENDSESSION:
      editctl=GETEDITCTL(w);
      if (SendMessage(editctl,EM_GETMODIFY,0,0))
        {
        int yn=MessageBox(w,"Exit without saving?",
          "Edit changed",MB_YESNO);
        if (yn==IDNO) return 0;
        }
      return 1;

/* Pass focus to edit control */
    case WM_SETFOCUS:
      editctl=GETEDITCTL(w);
      SetFocus(editctl);
      break;

/* Size edit control to fit */
    case WM_SIZE:
      {
      RECT r;
      editctl=GETEDITCTL(w);
      GetClientRect(w,&r);
      MoveWindow(editctl,0,0,r.right,r.bottom,TRUE);
      }
      break;

/* Convert close to WM_QUERYENDSESSION
   if closing, destroy window */
    case WM_CLOSE:
      if (SendMessage(w,WM_QUERYENDSESSION,1,0))
        DestroyWindow(w);
      return 0;

    case WM_DESTROY:
      RemoveProp(w,eprop);
      PostQuitMessage(0);
      return 0;
    }

  return DefWindowProc(w,msg,wParam,lParam);
  }

