/* Drag/size default procedure -- Williams */
#include <windows.h>
#include "dragsize.h"

/* Current selection */
static HWND sel=NULL;

/* Default window procedure */
LONG DefDSWindowProc(HWND w,UINT cmd,
  WPARAM wParam,LPARAM lParam)
  {
  switch (cmd)
    {
/* If button goes down, select window */
  case WM_NCLBUTTONDOWN:
    select(w,TRUE);
    break;

/* If mouse hits client area, tell it it is
   really caption area */
  case WM_NCHITTEST:
      {
      long tmp=DefWindowProc(w,cmd,wParam,lParam);
      if (tmp==HTCLIENT) tmp=HTCAPTION;
      return tmp;
      }
    }
  return DefWindowProc(w,cmd,wParam,lParam);
  }

/* Clear selection */
void unselect(BOOL frame)
  {
  if (sel)
    {
/* Turn off thick frame */
    SetWindowLong(sel,GWL_STYLE,
      GetWindowLong(sel,GWL_STYLE)
      &~WS_THICKFRAME|(frame?WS_BORDER:0));
/* Redraw frame */
    SetWindowPos(sel,NULL,0,0,0,0,
      SWP_DRAWFRAME|SWP_NOZORDER|SWP_NOMOVE|
      SWP_NOSIZE|SWP_SHOWWINDOW);
/* Clear selection */
    sel=NULL;
    }
  }

/* Return selected HWND */
HWND selected()
  {
  return sel;
  }

/* Set selection -- move to top if top==TRUE */
void select(HWND w,BOOL top)
  {
  HWND oldsel=sel;
/* Unselect current */
  if (sel) unselect(FALSE);
  sel=w;
/* If non-NULL selection... */
  if (w)
    {
/* Set thick frame on */
    SetWindowLong(w,GWL_STYLE,
      GetWindowLong(w,GWL_STYLE)
      &~WS_BORDER|WS_THICKFRAME);
/* Draw frame */
    SetWindowPos(w,NULL,0,0,0,0,SWP_DRAWFRAME|
      SWP_NOZORDER|SWP_NOMOVE|SWP_NOSIZE|
      SWP_SHOWWINDOW);
    if (top)  /* Set to top, if desired */
      SetWindowPos(sel,HWND_TOP,0,0,0,0,
        SWP_DRAWFRAME|SWP_NOMOVE|SWP_NOSIZE|
        SWP_SHOWWINDOW);
/* This update isn't needed in Win31, but makes drawing work
   better on Win32 platforms (even when running as Win16) */
    UpdateWindow(sel);
    }
/* This update isn't needed in Win31, but makes drawing work
   better on Win32 platforms (even when running as Win16) */
  if (oldsel) UpdateWindow(oldsel);
  }
