;================================================================
; Return a numeric value based on the 80x87 condition codes
; set by FXAM.  Assumes the status word has been stored in
; memory at Status.
;
; Registers In                          Registers Out
; -------------------------             -------------------------
; none                                  AX = value (0 - 15)
;================================================================

        ValueCC     proc
            mov     al, byte ptr [Status+1]
            and     al, 01000111b       ;mask off C3, C2-C0
            cbw
           test     al, 01000000b
             jz     Exit                ;if C3 not set
            xor     al, 01001000b       ;else combine w/C2-C0
Exit:
            ret
        ValueCC     endp
