/*
    Function: UnhookAndRestoreSysTimer
    Description:
        Undoes what HookAndProgramSysTimer does.
*/
void UnhookAndRestoreSysTimer(void far interrupt (*Address)())
{
    /* NOTE: set the vector first.  If this is not done, the */
    /*   user interrupt routine could still be called between the */
    /*   timer restoration and the vector restoration.  If this */
    /*   happened, the user interrupt could reinitialize the timer */
    /*   with the user-needed mode and count, clobbering the timer. */
    setvect(SYS_TIMER_INT, Address);
    RestoreSysTimer();
}

