/* TOUCHIT.CMD - An OS/2 REXX Utility
*  Touchit is used to update file dates and times.  Dates must be
*  in the range from 1/1/80 through 12/31/2099.  Times are in
*  24-hour format.
*  Call with: TOUCHIT ARG1 [,ARG2] [,...], where the ARGs are the
*  names of files to be "touched" ("wildcards" may be used).
*  TOUCHIT calls on the file TOUCHIT.DLL.  TOUCHIT.DLL must be in
*  the system LIBPATH (or have both TOUCHIT.DLL and TOUCHIT.CMD in
*  the default directory at execution time).
*
*              Copyright (C) 1994 by Murray L. Lesser
*/

/* Initialize */
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    call SysLoadFuncs
    call SysCls
    month.01 = 31    /* "Array" showing maximum days per month */
    month.02 = 28
    month.03 = 31
    month.04 = 30
    month.05 = 31
    month.06 = 30
    month.07 = 31
    month.08 = 31
    month.09 = 30
    month.10 = 31
    month.11 = 30
    month.12 = 31
/* Get command-line arguments */
    arg firstarg restargs
    if firstarg = "" then do
        say "sorry, this program requires an argument"
        "@PAUSE"     /* Hold, in case being run from WPS icon */
        exit
        end
GetDate:  /* Return here if invalid date */
    say
    say 'Enter the "TOUCHDATE" to be used in form "mm/dd/yy"',
        ' or "mm/dd/yyyy"'
    say '    else Press "ENTER" alone to use system date'
    pull touchdate
    if touchdate = "" then do
        touchdate = date('S')
        day = right(touchdate,2)
        month = substr(touchdate,5,2)
        year = left(touchdate,4)
        end     /* if...do */
    else call CheckDate     /* Test for valid keyed touchdate */
GetTime:  /* Return here if invalid time */
    say
    say 'Enter the "TOUCHTIME" to be used in form "hh:mm:ss"'
    say '     else Press "ENTER" alone to use system time'
    pull touchtime
    if touchtime = "" then,
        parse value time() with hour':'minute':'second
    else call CheckTime
    call SysCls
    say "TouchDate is" month'/'day'/'year
    say "TouchTime is" hour':'minute':'second
    say '    If this is OK:'
    call ResponseKey
    call RxFuncAdd 'TouchIt', 'TOUCHIT', 'TouchIt'
/* Locate files and touch them */
    do while firstarg <> ""
        if substr(firstarg,2,1) = ':' then drive = left(firstarg,1)
        else drive = left(directory(),1)
/* If this is a first reading from a diskette, is it ready? */
        select
            when drive = 'A' | drive = 'B' then,
                if pos(drive,driven) = 0 then call CheckDrive
            otherwise nop
            end /* select */
/* Find the file tree corresponding to the first argument */
        call SysFileTree firstarg, files, 'f', '**-*-'
        select
            when files.0 = 0 then say firstarg "not found"
            otherwise do i = 1 to files.0
                parse value files.i with . . . . filename
                filename = strip(filename)
                call 'TouchIt' filename, year, month, day, ,
                       hour, minute, second
                select
                    when result = 0 then,
                        say filename "was touched."
                    when result = 19 then do
                        say 'Drive' drive 'is write protected.'
                        say ' After checking drive:'
                        call ResponseKey
                        i = i - 1
                        end  /* then do */
                    otherwise say filename 'access is denied.'
                    end /* inner select */
                end /* outer otherwise */
            end /* outer select */
        parse var restargs firstarg restargs
        end  /* do while */
    call RxFuncDrop('TouchIt')
    "@PAUSE"
    exit
/* End of main program, start of subroutines in alphabetic order */
CheckDate:      /* Check keyed input date for validity */
    parse var touchdate month '/' day '/' year
/* Remove leading zeros (if any) from month and day */
    month = strip(month,'L','0')
    day = strip(day,'L','0')
    if datatype(month) <> 'NUM' |,
            datatype(day) <> 'NUM' |,
            datatype(year) <> 'NUM' then do
       say "Invalid input entry.  Try again."
       signal GetDate
       end  /* If...do */
    select  /* Correct the value of year */
        when year < 0 then checker = "invalid year"
        when year < 80 then year = 2000 + year
        when year < 100 then year = year + 1900
        when year < 1980 then checker = "invalid year"
        when year > 2099 then checker = "invalid year"
        otherwise nop
        end /* select for year */
/* check for month and day (insert leading zero if single-digit) */
    if length(month) = 1 then month = '0'month
    if length(day) = 1 then day = '0'day
    if month < 1 | month > 12 then checker = "invalid month"
    else do
        if day < 1 then checker = "invalid day"
        if year//4 = 0 then month.02 = 29
        if day > month.month then checker = "invalid day"
        end /* else...do */
    if checker <> "CHECKER" then do     /* Error in date */
        say "Input date had an" checker". Repeat entry"
        drop checker
        signal GetDate
        end /* If...do */
    return
CheckDrive:     /* If first time for this diskette drive */
    do forever
        if SysDriveInfo(drive) = "" then do
            say "Cannot read drive " drive
            say  "Either drive not ready,",
                 "or it contains an unformatted diskette."
            say "  After checking drive:"
            call ResponseKey
            end  /* If...do*/
        else leave
        end /* do forever */
    if driven = 'DRIVEN' then driven = drive
    else driven = driven || drive
    return
CheckTime:  /* Check keyed time input for validity */
    parse var touchtime hour':'minute':'second
    hour = strip(hour,'L','0')
    minute = strip(minute,'L','0')
    second = strip(second,'L','0')
    if hour = "" then hour = 00
    if minute = "" then minute = 00
    if second = "" then second = 00
    if datatype(hour) <> 'NUM' |,
             datatype(minute) <> 'NUM' |,
             datatype(second) <> 'NUM' then do
        say "Invalid input entry.  Try again."
        signal GetTime
        end  /* If...do */
    if hour < 0 | hour > 23 then checker = "invalid hour"
    if minute < 0 | minute > 59 then checker = "invalid minute"
    if second < 0 | second > 59 then checker = "invalid second"
    if checker <> "CHECKER" then do
        say "Input time had an" checker". Repeat entry"
        drop checker
        signal GetTime
        end /* If...do */
    if length(hour) = 1 then hour = '0'hour
    if length(minute) = 1 then minute = '0'minute
    if length(second) = 1 then second = '0'second
    return
ResponseKey:
    do while chars() <> 0   /* Clear type-ahead Buffer */
        call SysGetKey('NOECHO')
        end /* do while */
    say '         Press "ENTER" to continue,',
           'or Press "Escape" to quit.'
    do forever
        tester = SysGetKey('NOECHO')
        select
            when tester = D2C(27) then do    /* Escape */
                say '     ----Program Terminated by User----'
                "@PAUSE"
                exit
                end
            when tester = D2C(13) then leave  /* Enter */
            otherwise nop
            end /* Select */
        end /* do forever */
    return
/* End of file TOUCHIT.CMD */
