/*
    Function: ReadTimerCount
    Description:
        Given a timer number as input, the routine returns the current
        count.
*/
UINT16 ReadTimerCount(int Timer)
{
    UINT16 Count;
    UINT8 Mode;

    Mode = (Timer << 6) | LATCH_CNTR; /* mode and type are don't cares */

    outportb(COUNTER_MODE, Mode);

    Count = inportb(COUNTER_0 + Timer); /* get LSB */
    Count |= inportb(COUNTER_0 + Timer) << 8; /* get MSB */

    return Count;
}

