/****
 ORDSFXC.C

 Test ORDSFX macro and assembly language routine.

 Please Note:  This program was written to use a version
 of Michael Abrash's Zen Timer that was altered to make
 it callable from C.  If you don't have the Zen Timer or
 you haven't created a C-callable version of it you must
 substitute some other timer, such as the C library clock()
 routine.  The .EXE file that accompanies this distribution
 contains the Zen Timer within it, so if you want to make
 changes and recompile, you may want to keep a copy of
 the original executable around.

 This program compiles under Turbo C, and uses some names
 specific to the Turbo C libraries.  Nothing here is so
 complex, however, that substitutes aren't easily found
 in the libraries of other compilers.  The directories
 named in the .TC configuration file are:

     \tc\lib -- for libraries and start-up module
     \tc\inc -- for header files

 If you've given your directories different names,
 make the necessary changes in the Turbo C IDE's
 Options/Directories section.
****/

#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <time.h>

/****
 Remove this #include and all calls to ZTimerOn,
 ZTimerOff, and ZTimerReport if you recompile
 without the Zen Timer.
****/

#include "pztimer.h"

typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
typedef char far *      FPC;

#define KEYREAD         bioskey(0)
#define KEYREADY        bioskey(1)
/****
 Stop execution on any key, resume on any subsequent key.
 PAUSE throws away the key that initiated the pause,
 then waits for another key and throws that away, too.
****/
#define PAUSE           {KEYREAD;while(!KEYREADY);KEYREAD;}

/**** Pointer to Print Function ****/

static int cdecl        (* pOut)(const char *, ... );

/**** ORDSFX Macro ****/

#define ORDSFXM(x)                                  \
 ((x) > 10 && (((x) - 10) % 100) / 10 == 0 ? "th" : \
                             (x) % 10 == 1 ? "st" : \
                             (x) % 10 == 2 ? "nd" : \
                             (x) % 10 == 3 ? "rd" : \
                                             "th" )

/**** Ordsfx() Function ****/

FPC far                 ordsfx( int, const FPC );

static int              Break;      /* save BREAK status    */
static char             CrLf[3];    /* EOL string           */
static char             Sfx [3];    /* holds suffix string  */

/**** Trap Ctrl-C/Break ****/

int ctrlbreak( void )
 {
 setcbrk( Break );
 return( 0 );
 }

/**** Main ****/

void main( void )
 {
 int        i, j, k;
 WORD       d_info;                 /* device info */

/* turn off CGA snow control flag in */
/* undoc'd Turbo C video data table  */

#if defined(__TURBOC__)
 extern char _video;
 *((char *)&_video + 10) = '\0';
#endif

 Break = getcbrk();
 setcbrk( 1 );
 ctrlbrk( ctrlbreak );

 /* check for redirected stdout */

 d_info = (WORD) ioctl( 1, 0 );
 if ( (d_info & 0x83) == 0x83 )
  {
  /* print to screen */
  clrscr();
  pOut = cprintf;
  *((WORD *)&CrLf) = 0x0A0D;
  }
 else
  {
  /* print to file/dev */
  pOut = printf;
  *CrLf = '\n';
  }
 pOut
  (
  "                Time              %s"
  "Function       (usec)      Output %s"
  "----------     ------     --------%s"
  , CrLf, CrLf, CrLf
  );
 /****
  Test positive numbers only by substituting desired
  range here, and substituting "%6u" for "%6d" in the
  output statements below.
 ****/
 for ( i = -30000 ; i < 30000 ; i += 3000 )
  {
  /* test at least 1st-4th, 11th-14th, and 21st-24th */
  for ( j = 0 ; j < 25 ; j++ )
   {
   /* pause only if output goes to screen */
   if ( pOut == cprintf && KEYREADY )
    PAUSE;
   k = i < 0 ? i - j : i + j;
   ZTimerOn();
   ORDSFXM(k);
   ZTimerOff();
   pOut
    (
    "%-10s     %6u     %6d%s%s"
    , "macro"
    , ZTimerReport()
    , k
    , ORDSFXM(k)
    , CrLf
    );
   ZTimerOn();
   ordsfx( k, Sfx );
   ZTimerOff();
   pOut
    (
    "%-10s     %6u     %6d%s%s"
    , "ordsfx"
    , ZTimerReport()
    , k
    , (char *) ordsfx( k, Sfx )
    , CrLf
    );
   pOut( "%s", CrLf );
   }
  }
 setcbrk( Break );
 }

/**** EOF:  ORDSFXC.C ****/
