;================================================================
; ORDSFX.ASM
; C callable routine for tacking an ordinal suffix onto a
; decimal number.  Parameters are the number and a three-byte
; buffer to  receive the suffix and terminating null byte.
; Returns far pointer to buffer.  May be used with any but the
; huge memory model.
;    Make .obj:     tasm /ml/t/w2/z ordsfx;
;  C prototype:     char far * far ordsfx(int, char far *);
;       Author:     Richard Zigler
; Based on a C macro by LeLand N Van Allen, "HAX 104", PC
; Techniques, Feb/Mar 1992.  The macro, corrected to check for
; x>10 in the first term, is:
; #define ORDSFX(x) ((x)>10&&(((x)-10)%100)/10 == 0 ? "th" : \
;                                       (x)%10 == 1 ? "st" : \
;                                       (x)%10 == 2 ? "nd" : \
;                                       (x)%10 == 3 ? "rd" : \
;                                                     "th" )
;================================================================
         locals     @_        ;@_ prefixes local symbols
         .model     small, c
          .data
Th           db     'th', 0
St           db     'st', 0             ;ST is reserved word
Nd           db     'nd', 0             ; if assembled with /mu
Rd           db     'rd', 0
SfxTbl       dw     offset Th, offset St, offset Nd
             dw     offset Rd, offset Th, offset Th
             dw     offset Th, offset Th, offset Th
             dw     offset Th
          .code
         public     ordsfx
         ordsfx     proc far
           uses     si, di
            arg     num       : word
            arg     pbuffer   : far ptr byte
         assume     ds:@data
            cld
            les     di, [pbuffer]
            mov     ax, [num]
            cwd
            xor     ax, dx
            sub     ax, dx              ;AX = |num|
            sub     dx, dx
            mov     cx, ax
            mov     si, 10
            sub     ax, si
            jbe     @_Mod10             ;if num <= 10
            mov     bx, 100
            div     bx
            mov     ax, dx              ;AX = (num-10)%100
            cwd
            div     si                  ;AX = ((num-10)%100)/10
            mov     bx, ax              ;AX = 0 - 9
            and     ax, ax
             jz     @_LoadPtr2
            mov     bx, dx
@_LoadPtr1:
            shl     bx, 1
@_LoadPtr2:
            mov     si, [SfxTbl+bx]
          movsw
          movsb
            mov     dx, es                        ;return far
            mov     ax, word ptr [pbuffer]        ; ptr to char
            ret
@_Mod10:
            mov     ax, cx              ;AX = |num|
            div     si
            mov     bx, dx              ;BX = num%10
            jmp     short @_LoadPtr1
         ordsfx     endp
            end
;**** EOF:  ORDSFX.ASM ****

