#ifndef _joystick_h
#define _joystick_h

  /*things used by joystick.c*/
#define JS_INT 0x15 /* the BIOS call */
#define JS_FNCT 0x84 /* the BIOS function */
#define JS_PORT 0x201 /* the IO port */

 /* I've never seen more than 500 needed but ? */
#define JS_TIMEOUT 1000

  /*return the value of the joystick*/
#define JS_A_X(x) (x.js_ax)
#define JS_A_Y(x) (x.js_ay)
#define JS_B_X(x) (x.js_bx)
#define JS_B_Y(x) (x.js_by)

  /*return the calabrated value of the joystick*/
#define JS_ACX(x) *(x.js_ax_nrm + (x.js_ax))
#define JS_ACY(x) *(x.js_ay_nrm + (x.js_ay))
#define JS_BCX(x) *(x.js_bx_nrm + (x.js_bx))
#define JS_BCY(x) *(x.js_by_nrm + (x.js_by))

  /*return the value of the buttons*/
#define JS_A_1(x) (x.js_but & 0x10)
#define JS_A_2(x) (x.js_but & 0x20)
#define JS_B_1(x) (x.js_but & 0x40)
#define JS_B_2(x) (x.js_but & 0x80)

struct joystick {
 /* values read from stick */
	short js_ax, js_ay, js_bx, js_by, js_but;
 /* range values read from stick */
	short js_ax_min, js_ax_ctr, js_ax_max;
	short js_ay_min, js_ay_ctr, js_ay_max;
	short js_bx_min, js_bx_ctr, js_bx_max;
	short js_by_min, js_by_ctr, js_by_max;
  /* normalized stick position table pointers */
	int *js_ax_nrm, *js_ay_nrm, *js_bx_nrm, *js_by_nrm;
	};

  /* functions */
extern int  js_get(); /* fast poll */
extern int  js_bios(); /* bios function */
extern void js_init(); /* table alloc */
extern void js_free(); /* table unalloc */
extern void js_calabrate(); /* calabration function */
extern void js_dotable(); /* fills lookup table */
#endif /*_joystick_h*/
