/* A demo of how to use the joystick code */
#include "joystick.h"

#define printjoy(x) \
  printf("%3i, %3i, %3i, %3i %c%c%c%c\r", \
    JS_A_X(x), JS_A_Y(x),\
    JS_B_X(x), JS_B_Y(x),\
    JS_A_1(x) ? '*' : ' ', JS_A_2(x) ? '*' : ' ',\
    JS_B_1(x) ? '*' : ' ', JS_B_2(x) ? '*' : ' ')

#define printjoycal(x) \
  printf("%3i, %3i, %3i, %3i %c%c%c%c\r", \
    JS_ACX(x), JS_ACY(x),\
    JS_BCX(x), JS_BCY(x),\
    JS_A_1(x) ? '*' : ' ', JS_A_2(x) ? '*' : ' ',\
    JS_B_1(x) ? '*' : ' ', JS_B_2(x) ? '*' : ' ')

main()
{
  struct joystick js;
  int i;
  printf("Using the js_bios function\n");
  while(1) {
    js_bios(&js);
    printjoy(js);
    if (kbhit() && getch() == ' ') break;
    }
  printf("\nUsing the js_get function\n");
  while(1) {
    js_get(&js);
    printjoy(js);
    if (kbhit() && getch() == ' ') break;
    }

  printf("\nUsing the js_get calibrated to -5, 5\n");
  js_init(&js); /* allocating js calibration tables */
  js_calibrate(&js); /* get the min, max, and center */

  /* filling in the lookup tables */
  js_dotable(&js, 0x0F, -5, 0, 5, 10, 10);
  while(1) {
    js_get(&js);
    printjoycal(js);
    if (kbhit() && getch() == ' ') break;
    }
  printf("\ndone. freeing the js calabration tables\n");
  js_free(&js);
}
