;================================================================
; Return an index based on the 80x87 condition codes set by
; FCOM and FTST.  Assumes the status word has been stored in
; memory at Status.
;
; Registers In                          Registers Out
; -------------------------             -------------------------
; none                                  AX = destroyed
;                                       BX = index
;                                          = 0 if ST>source/0.0
;                                          = 1 if ST<source/0.0
;                                          = 2 if ST=source/0.0
;                                          = 3 if undefined
;================================================================

        IndexCC     proc
            mov     ah, byte ptr [Status+1]

           sahf               ;condition codes=>CPU flags
                              ;  -- C3 -- -- -- C2 C1 C0
                              ;  SF ZF -- AF -- PF -- CF
                              ;---------------------------
                              ;      0           0 xx  0
                              ;      0           0 xx  1
                              ;      1           0 xx  0
                              ;      1           1 xx  1
                              ;---------------------------

             jp     Undef     ;if C2 set
             jz     Equal     ;if C3 set
            sbb     bx, bx    ;BX = 0 or -1
            neg     bx        ;BX = 0 or  1
            ret
Equal:
            mov     bx, 2
            ret
Undef:
            mov     bx, 3
            ret
        IndexCC     endp

