/*
    Function: HookAndProgramSysTimer
    Description:
        Redirects the system timer and programs it with a new count.
        Note that simply redirecting the timer without reprogramming
        it can be done with the setvect command.  The routine
        returns the previous system timer vector.  BE SURE TO
        RESTORE THE TIMER INTERRUPT USING THIS VECTOR BEFORE THE
        PROGRAM EXITS!!
*/
void far interrupt (*HookAndProgramSysTimer
    (
    void far interrupt (*Address)(),
    UINT8 Mode,
    UINT16 Count
    ))()
{
    void far interrupt (*RetVal)();

    Mode &= 0x3F; /* make sure we're setting counter 0 */

    assert(GET_RWL(Mode) != 0); /* catch latch command */

    RetVal = getvect(SYS_TIMER_INT);
    ProgramTimer(Mode, Count);
    setvect(SYS_TIMER_INT, Address);

    return RetVal;
}

