
/* File: GAMEDEFS.H
** Description:
**   Contains general type defs.
*/

#ifndef _GAMEDEFS_H

typedef char 			INT8;
typedef unsigned char 	UINT8;
typedef int				INT16;
typedef unsigned int    UINT16;
typedef long            INT32;
typedef unsigned long   UINT32;

typedef unsigned int	WORD;
typedef unsigned long	LONG;

typedef int				BOOL;

#define TRUE (1)
#define FALSE (0)

#define DIM(x) (sizeof(x)/sizeof(x[0]))

#define LOWBYTE(x) ((x) & 0xFF)
#define HIGHBYTE(x)	(((x) >> 8) & 0xFF)

/* just define these in terms of the Borland library macros */
#define MIN(a,b) min(a,b)
#define MAX(a,b) max(a,b)

/* interrupt acknowledgement stuff */
#define PIC					(0x20)
#define NONSPECIFIC_EOI		(0x20)

typedef struct {
	int Top;
    int Left;
    int Bottom;
    int Right;
} RECT;

#define _GAMEDEFS_H

#endif
