#ifndef _WINDOW_H
#define _WINDOW_H

#if defined(_WIN32) || defined(__WIN32__)
#define EXPORT
#else
#define EXPORT _export
#endif

#include <windows.h>
#include "dc.h"
#include "rect.h"

class  Window
  {
  protected:
  HWND hwnd;
  PAINTSTRUCT ps;
  static LONG CALLBACK EXPORT ccb(HWND w,UINT cmd,WPARAM wParam,LPARAM lParam);
  FARPROC subclasscb;
  static char classname[];
  static BOOL reg;
  public:
  virtual char *GetClass(void) { return classname; };
  static ATOM THIS1;
  static ATOM THIS2;
  static Window FAR *GetWin(HWND w);
  Window() { hwnd=NULL; subclasscb=(FARPROC)DefWindowProc; };
  Window(HWND w) { hwnd=w; subclasscb=(FARPROC)::GetWindowLong(w,GWL_WNDPROC); };
  HWND Create(LPSTR name,LONG style=WS_OVERLAPPEDWINDOW,int x=CW_USEDEFAULT,
    int y=CW_USEDEFAULT,int wid=CW_USEDEFAULT,int hi=CW_USEDEFAULT,
    Window *parent=NULL,HMENU menu=NULL);
  virtual ATOM Register(LPSTR menu=NULL,HBRUSH backg=(HBRUSH)(COLOR_WINDOW+1),
     HICON icon=NULL,HCURSOR cursor=NULL);
  FARPROC Subclass(FARPROC fp) { FARPROC t; t=fp; subclasscb=fp; return t;};
  virtual LONG CallBack(UINT cmd,WPARAM wParam,LPARAM lParam);
  virtual void Paint(DC &dc);
  virtual void OnCreate(LPCREATESTRUCT lp) { };
  virtual void Key(int key) { };
  virtual void Size(Rect &r) { };
  virtual void Activate(int flag,BOOL min) { };
  virtual int GetMinMaxInfo(MINMAXINFO FAR *info) { return 1;};
  virtual int OnSetFocus(Window FAR *w) { return 1; };
  virtual int OnKillFocus(Window FAR *w) { return 1; };
/* This should pass a Window *, but for now it is a HWND */
  virtual void OnScroll(BOOL vbar,int sval,int spos,HWND sb) { };
  DC BeginPaint(void);
  void EndPaint(void) { ::EndPaint(hwnd,&ps); };
  HWND GetWindow(void) { return hwnd; };
  LONG GetWindowLong(int off) { return ::GetWindowLong(hwnd,off); };
  LONG SetWindowLong(int off,DWORD wrd) { return ::SetWindowLong(hwnd,off,wrd); };
  WORD GetWindowWord(int off) { return ::GetWindowWord(hwnd,off); };
  WORD SetWindowWord(int off,WORD wrd) { return ::SetWindowWord(hwnd,off,wrd); };
  void GetClientRect(Rect &r) { ::GetClientRect(hwnd,r.GetRect()); };
  void GetWindowRect(Rect &r) { ::GetWindowRect(hwnd,r.GetRect()); };
  void Show(int state) { ::ShowWindow(hwnd,state); };
  void Update(void) { ::UpdateWindow(hwnd); };
  void DestroyWindow(void) { ::DestroyWindow(hwnd); };
  int MessageBox(LPCSTR str,LPCSTR title=NULL,int f=MB_OK) { return ::MessageBox(hwnd,str,title,f); };
  virtual LONG Command(int id,WPARAM w) { return 0; };
  virtual void Close(void) { ::DestroyWindow(hwnd); };
  virtual void Destroy(void) { };
  virtual void Move(int x,int y) { };
  virtual void Mouse(int f,POINT p,int wParam) { };
  virtual void Idle(void) { };
  BOOL PostMessage(UINT m,WPARAM w,LPARAM l) { return ::PostMessage(hwnd,m,w,l); };
  LRESULT SendMessage(UINT m,WPARAM w,LPARAM l) { return ::SendMessage(hwnd,m,w,l); };
  int GetClassName(LPSTR s,int l) { return ::GetClassName(hwnd,s,l); };
  BOOL IsChild(Window &w) { return ::IsChild(hwnd,w.GetWindow()); };
  Window FAR *GetParent(void) { HWND ww=::GetParent(hwnd); return Window::GetWin(ww); };
  Window FAR *SetParent(Window &w) { HWND ww=::SetParent(hwnd,w.GetWindow()); return Window::GetWin(ww); };
  BOOL IsWindowVisible(void) { return ::IsWindowVisible(hwnd); };
  BOOL EnableWindow(BOOL f) { return ::EnableWindow(hwnd,f); };
  BOOL IsWindowEnabled(void) { return ::IsWindowEnabled(hwnd); };
  void SetWindowText(LPCSTR s) { ::SetWindowText(hwnd,s); };
  int GetWindowText(LPSTR s,int l) { return ::GetWindowText(hwnd,s,l); };
  int GetWindowTextLength(void) { return ::GetWindowTextLength(hwnd); };
  BOOL GetWindowPlacement(WINDOWPLACEMENT FAR *w) { return ::GetWindowPlacement(hwnd,w); };
  BOOL SetWindowPlacement(const WINDOWPLACEMENT FAR *w) { return ::SetWindowPlacement(hwnd,w); };
  BOOL SetWindowPos(Window &ref,int a,int b,int c,int d,UINT e)
    {
    return ::SetWindowPos(hwnd,ref.GetWindow(),a,b,c,d,e);
    };
  BOOL MoveWindow(int a,int b,int c,int d,BOOL redraw=TRUE) { return ::MoveWindow(hwnd,a,b,c,d,redraw); };
  BOOL BringWindowToTop(void) { return ::BringWindowToTop(hwnd); };
  BOOL FlashWindow(BOOL x=TRUE) { return ::FlashWindow(hwnd,x); };
  void ShowOwnedPopups(BOOL x=TRUE) { ::ShowOwnedPopups(hwnd,x); };
  void ClientToScreen(POINT FAR *p) { ::ClientToScreen(hwnd,p); };
  void ScreenToClient(POINT FAR *p) { ::ScreenToClient(hwnd,p); };
  Window FAR *ChildWindowFromPoint(POINT p) { HWND w=::ChildWindowFromPoint(hwnd,p); return Window::GetWin(w); };
  BOOL EnumChildWindows(WNDENUMPROC p,LPARAM l) { return ::EnumChildWindows(hwnd,p,l); };
  Window FAR *GetTopWindow(void) { HWND w=::GetTopWindow(hwnd); return Window::GetWin(w); };
  Window FAR *GetWindow(UINT f) { HWND w=::GetWindow(hwnd,f); return Window::GetWin(w); };
  Window FAR *SetFocus(void) { HWND w=::SetFocus(hwnd); return Window::GetWin(w); };
  DC GetWindowDC(void);
  BOOL GetUpdateRect(Rect &r,BOOL flag=TRUE) { return ::GetUpdateRect(hwnd,r.GetRect(),flag); };
  int GetUpdateRgn(HRGN r,BOOL flag=TRUE) { return ::GetUpdateRgn(hwnd,r,flag); };
  void InvalidateRect(const Rect *r=NULL,BOOL flag=TRUE) { ::InvalidateRect(hwnd,r?r->GetRectC():NULL,flag); };
  void ValidateRect(const Rect *r) { ::ValidateRect(hwnd,r?r->GetRectC():NULL); };
  void InvalidateRgn(HRGN r,BOOL flag=TRUE) { ::InvalidateRgn(hwnd,r,flag); };
  void ValidateRgn(HRGN r) { ::ValidateRgn(hwnd,r); };
  BOOL RedrawWindow(const Rect *r,HRGN u,UINT flag) { return ::RedrawWindow(hwnd,r?r->GetRectC():NULL,u,flag); };
  void ScrollWindow(int a,int b,const Rect *r,const Rect *r2) { ::ScrollWindow(hwnd,a,b,r?r->GetRectC():NULL,r?r->GetRectC():NULL); };

  };

#endif
