/* Window object -- Williams */
#include "window.h"
#include "app.h"

char Window::classname[]="CPPClass";
ATOM Window::THIS1;  // atoms for properties
ATOM Window::THIS2;  // to store Window *
int Window::reg=0;   // registered flag


/* C-language callback */
LONG CALLBACK EXPORT Window::ccb(HWND w,UINT cmd,WPARAM wParam,LPARAM lParam)
  {
  Window *win;
  if (cmd==WM_NCCREATE)
    {
/* Save callback in first extra word */
    LPCREATESTRUCT cs=(LPCREATESTRUCT)lParam;
    ::SetWindowLong(w,0,(DWORD)cs->lpCreateParams);
    win=(Window *)cs->lpCreateParams;
    win->hwnd=w;
    }
/* Call C++ callback */
  win=(Window *)::GetWindowLong(w,0);
  return win?win->CallBack(cmd,wParam,lParam):
    DefWindowProc(w,cmd,wParam,lParam);
  }

DC Window::BeginPaint(void)
  {
  ::BeginPaint(hwnd,&ps);
  DC rv(&ps);
  return rv;
  }

LONG Window::CallBack(UINT cmd,WPARAM wParam,LPARAM lParam)
  {
  switch (cmd)
    {
    case WM_CREATE:
      OnCreate((LPCREATESTRUCT)lParam);
      break;

    case WM_CHAR:
      Key((int)wParam);
      break;

    case WM_CLOSE:
      Close();
      break;

    case WM_DESTROY:
      Destroy();
      break;

    case WM_MOVE:
      Move(LOWORD(lParam),HIWORD(lParam));
      break;

    case WM_PAINT:
      Paint(BeginPaint());
      EndPaint();
      return 0;

    case WM_SIZE:
      /* Win32 parameters are strange therefore... */
      {
      Rect r;
      GetClientRect(r);
      Size(r);
      return 0;
      }

    case WM_ACTIVATE:
      {
#ifdef _WIN32
      Activate(LOWORD(wParam),(BOOL)HIWORD(wParam));
#else
      Activate(wParam,(BOOL)HIWORD(lParam));
#endif
      return 0;
      }

    case WM_GETMINMAXINFO:
      if (!GetMinMaxInfo((MINMAXINFO FAR *)lParam))
         return 0;
      break;

    case WM_SETFOCUS:
      {
      Window FAR *w=wParam?GetWin((HWND)wParam):NULL;
      if (!OnSetFocus(w))
        return 0;
      break;
      }

    case WM_KILLFOCUS:
      {
      Window FAR *w=wParam?GetWin((HWND)wParam):NULL;
      if (!OnKillFocus(w))
        return 0;
      break;
      }

    case WM_HSCROLL:
    case WM_VSCROLL:
      {
#ifdef _WIN32
      OnScroll(cmd==WM_VSCROLL?TRUE:FALSE,LOWORD(wParam),
        HIWORD(wParam),(HWND)lParam);
#else
      OnScroll(cmd==WM_VSCROLL?TRUE:FALSE,wParam,
        LOWORD(lParam),(HWND)HIWORD(lParam));
#endif
      }

    case WM_MOUSEMOVE:
    case WM_LBUTTONDOWN:
    case WM_LBUTTONUP:
    case WM_LBUTTONDBLCLK:
    case WM_RBUTTONDOWN:
    case WM_RBUTTONUP:
    case WM_RBUTTONDBLCLK:
    case WM_MBUTTONDOWN:
    case WM_MBUTTONUP:
    case WM_MBUTTONDBLCLK:
        {
        POINT p;
        p.x=LOWORD(lParam);
        p.y=HIWORD(lParam);
        Mouse(cmd,p,wParam);
        return 0;
        }

    case WM_COMMAND:
      return Command(wParam,HIWORD(lParam));

    }
  return ((WNDPROC)subclasscb)(hwnd,cmd,wParam,lParam);
  }

void Window::Paint(DC &dc)
  {
  dc.TextOut(0,0,"Howdy!");
  }

HWND Window::Create(LPSTR name,LONG style,int x,int y,
  int wid,int hi,Window *parent, HMENU menu)
  {
  HWND w;
  if (!reg)
    Register();
  w=CreateWindow(GetClass(),name,style,x,y,wid,hi,
    parent?parent->GetWindow():NULL,menu,APP::app->GethInstance(),(LPVOID)this);
  if (w)
    {
    ::SetProp(w,MAKEINTATOM(THIS1),(HANDLE)HIWORD(this));
    ::SetProp(w,MAKEINTATOM(THIS2),(HANDLE)LOWORD(this));
    }

  return w;
  }

ATOM Window::Register(LPSTR menu,HBRUSH backg,HICON icon,HCURSOR cursor)
  {
  WNDCLASS wc;
  reg=1;
  wc.style=CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;
  wc.lpfnWndProc=Window::ccb;
  wc.cbClsExtra=0;
  wc.cbWndExtra=4;
  wc.hInstance=APP::app->GethInstance();
  wc.hIcon=icon?icon:APP::app->GetIcon();
  wc.hCursor=cursor?cursor:LoadCursor(NULL,IDC_ARROW);
  wc.hbrBackground=backg;
  wc.lpszMenuName=menu;
  wc.lpszClassName=GetClass();
  return RegisterClass(&wc);
  }

Window FAR *Window::GetWin(HWND w)
  {
  WORD l=(WORD)::GetProp(w,MAKEINTATOM(Window::THIS1));
  WORD h=(WORD)::GetProp(w,MAKEINTATOM(Window::THIS2));
  return (Window FAR *)MAKELONG(l,h);
  }

DC Window::GetWindowDC(void)
  {
  HDC hdc=::GetWindowDC(hwnd);
  DC odc(hdc);
  return odc;
  }
