#ifndef _RECT_H
#define _RECT_H

#include <windows.h>
class Rect
  {
  protected:
  RECT rect;
  public:
  Rect(int x0=0,int y0=0,int x1=0,int y1=0) { rect.left=x0; rect.top=y0; rect.right=x1; rect.bottom=y1; };
  Rect(RECT &r) { rect=r; };
  LPRECT GetRect(void) { return &rect; };
  const LPRECT GetRectC(void) const {return (const LPRECT)&rect; };
  int Left(void) const { return rect.left; };
  int Top(void) const { return rect.top; };
  int Right(void) const { return rect.right; };
  int Bottom(void) const { return rect.bottom; };
  int Width(void) const { return rect.right-rect.left; };
  int Height(void) const { return rect.bottom-rect.top; };
  BOOL IsRectEmpty(void) { return ::IsRectEmpty(&rect); };
  BOOL PtInRect(POINT p) { return ::PtInRect(&rect,p); };
  void InflateRect(int w,int h) { ::InflateRect(&rect,w,h); };
  BOOL operator==(Rect& r2) { return EqualRect(&rect,r2.GetRect()); };
  };
#endif
