/* Quiz program -- Williams */
#include <windows.h>
#include "quiz.h"

/* Use C Browse module */
extern "C" {
#include "browse.h"
HANDLE hInst;  // required for browse
}

#include <ctype.h>


int PASCAL WinMain(HINSTANCE inst,HINSTANCE prev,LPSTR cmdline,int show)
  {
  QuizApp the_app(inst,prev,cmdline,show);
  hInst=inst;
  if (!the_app.Init()) return 0;
  return the_app.Run();
  }


char QuizWindow::classname[]="DemoClass";

BOOL QuizApp::Init(void)
  {
  QuizWindow *win;
  win=new QuizWindow;
  mainwin=win;
  if (!win->Create("Quiz Master",WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,
    CW_USEDEFAULT,500,300,NULL,APP::app->LoadMenu(MAINMENU))) return FALSE;
/* Set up buttons */
  for (int i=0;i<3;i++)
    {
    char ids[2];
    ids[1]='\0';
    ids[0]='A'+i;
    win->button[i]=new PushButton;
    win->button[i]->Create(ids,0,30,55+i*25,50,20,
      win,200+i);
    }
  win->Show(show);
  win->Update();
  return TRUE;
  }

void QuizWindow::Paint(DC &dc)
  {
  int x=10,y=10;
  Rect r;
  char ws[81];
  GetClientRect(r);
  dc.SetTextAlign(TA_LEFT);
  dc.SetTextColor(RGB(0xFF,0,0));
/* Output Score */
  wsprintf(ws,"Score=%d",score*10);
  dc.TextOut(x,y,ws);
  if (!*quest) return;
  dc.SetTextColor(RGB(0,0,0xFF));
/* Output question */
  y=30;
  dc.TextOut(x,y,quest);
/* Output answers */
  dc.SetTextColor(RGB(0,0x80,0xFF));
  x=100;
  y=55;
  for (int i=0;i<3;i++)
    {
    dc.TextOut(x,y,answer[i]);
    y+=25;
    }
  }

/* Answer by key */
void QuizWindow::Key(int key)
  {
  key=toupper(key);
  if (key>='A'&&key<='C')
    Answer(key);
  }

/* Open a new file */
void QuizWindow::Open(void)
  {
  char fn[_MAX_PATH];
  *fn='\0';
  if (!get_file(hwnd,fn,_MAX_PATH,"Select Quiz File",
    "Quiz files\0*.qiz\0All Files\0*.*",FALSE))
    quiz.SetFile(fn);
  score=maxscore=0;
  current=0;
  Next();
  }

/* Test over -- put down your pencil! */
void QuizWindow::Done(void)
  {
  char tmp[128];
  InvalidateRect();
  Update();
  wsprintf(tmp,"You scored %d out of a possible %d",
    score*10,maxscore*10);
  MessageBox(tmp,"Game Over");
  }

/* Process answers */
void QuizWindow::Answer(int c)
  {
  if (!*quest) return;   /* No active question */
  c=toupper(c)-'A';
  if (c==correct)
    {
    score++;
    MessageBeep(MB_ICONEXCLAMATION);
    }
  else
    MessageBox(answer[correct],"The correct answer was");
  maxscore++;
  Next();
  }

/* Move to next question */
void QuizWindow::Next(void)
  {
  char temp[128],tag[33],ids[2];
  int i;
  current++;
  wsprintf(tag,"Question %d",current);
  quiz.Get(tag,"Q","",quest,sizeof(quest));
  if (!*quest)
    {
    Done();
    return;
    }
  ids[1]='\0';
  for (i=0;i<3;i++)
    {
    ids[0]='A'+i;
    quiz.Get(tag,ids,"",temp,sizeof(temp));
    if (*temp=='*')
      {
      correct=i;
      lstrcpy(answer[i],temp+1);
      }
    else
      lstrcpy(answer[i],temp);
    }
  InvalidateRect();
  }

void QuizWindow::OnCreate(LPCREATESTRUCT lp)
   {
   Next();  // start questios
   }

/* Process menu/buttons */
LONG QuizWindow::Command(int id,WPARAM w)
  {
  if (id>=200&&id<=202)
    {
    Answer(id-200+'A');
    SetFocus();
    }
  if (id==OPENMENU) Open();
  if (id==EXITMENU) DestroyWindow();
  if (id==ABTMENU) MessageBox("QuizMaster by Al Williams","About");
  if (id==STARTMENU)
    {
    score=maxscore=current=0;
    Next();
    }
  return 0;
  }
