#ifndef _INI_H
#define _INI_H
#include <windows.h>
#include <stdlib.h>

class IniFile
  {
  protected:
  char inifile[_MAX_PATH];
  public:
  IniFile(char *f="WIN.INI") { lstrcpy(inifile,f); };
  void SetFile(char *fn) { lstrcpy(inifile,fn); };
  int Get(LPCSTR sec,LPCSTR key,LPCSTR def,LPSTR buf,int len)
    {
    return ::GetPrivateProfileString(sec,key,def,buf,len,inifile);
    };
  int Get(LPCSTR sec,LPCSTR key,int def)
    {
    return ::GetPrivateProfileInt(sec,key,def,inifile);
    };
  BOOL Put(LPCSTR sec,LPCSTR key,LPCSTR val)
    {
    return ::WritePrivateProfileString(sec,key,val,inifile);
    };
  BOOL Put(LPCSTR sec,LPCSTR key,int val)
    {
    char tmp[33];
    wsprintf(tmp,"%d",val);
    return ::WritePrivateProfileString(sec,key,tmp,inifile);
    };
  };

#endif
