/* DC Object -- Williams */
#ifndef _DC_H
#define _DC_H

#include <windows.h>
#include "rect.h"

class Window;

class DC
  {
  protected:
  HDC dc;       // base dc
  int release;  // flag shows how to release DC
  Window *win;  // Associated Window
  public:
  DC(Window &w);
  DC(HDC hdc) { release=0; dc=hdc; };
  DC(LPPAINTSTRUCT ps) { release=2; dc=ps->hdc; };
  ~DC();
  HDC GetHDC(void) { return dc; };
  DC *CreateCompatibleDC() { DC *odc; HDC hdc; hdc=::CreateCompatibleDC(dc); odc=new DC(hdc); return odc; };
#if defined(_WIN32) || defined(__WIN32__)
// Need corresponding Win32 functions here e.g....
  BOOL GetDCOrg(LPPOINT p) { return ::GetDCOrgEx(dc,p); };
#define LCAST DWORD
  #else
#define LCAST LPSTR
  DWORD GetDCOrg(void) { return ::GetDCOrg(dc); };
  DWORD SetWindowOrg(int x,int y) { return ::SetWindowOrg(dc,x,y); };
  DWORD GetWindowOrg(void) { return ::GetWindowOrg(dc); };
  DWORD SetWindowExt(int x,int y) { return ::SetWindowExt(dc,x,y); };
  DWORD GetWindowExt(void) { return ::GetWindowExt(dc); };
  DWORD OffsetWindowOrg(int x,int y) { return ::OffsetWindowOrg(dc,x,y); };
  DWORD ScaleWindowExt(int a,int b, int c, int d) { return ::ScaleWindowExt(dc,a,b,c,d); };
  DWORD SetViewportOrg(int x,int y) { return ::SetViewportOrg(dc,x,y); };
  DWORD GetViewportOrg(void) { return ::GetViewportOrg(dc); };
  DWORD SetViewportExt(int x,int y) { return ::SetViewportExt(dc,x,y); };
  DWORD GetViewportExt(void) { return ::GetViewportExt(dc); };
  DWORD OffsetViewportOrg(int x,int y) { return ::OffsetViewportOrg(dc,x,y); };
  DWORD ScaleViewportExt(int a,int b,int c,int d) { return ::ScaleViewportExt(dc,a,b,c,d); };
  DWORD SetBrushOrg(int x,int y) { return ::SetBrushOrg(dc,x,y); };
  DWORD GetBrushOrg(void) { return ::GetBrushOrg(dc); };
  BOOL MoveTo(int x,int y,POINT FAR *pt) { return ::MoveToEx(dc,x,y,pt); };
  DWORD GetCurrentPostion(void) { return ::GetCurrentPosition(dc); };
  DWORD GetTextExtent(LPCSTR s,int l) { return ::GetTextExtent(dc,s,l); };
  DWORD GetTextExtent(LPCSTR s) { return ::GetTextExtent(dc,s,lstrlen(s)); };
  DWORD GetAspectRatioFilter(void) { return ::GetAspectRatioFilter(dc); };
  DWORD MoveTo(int x,int y) { return ::MoveTo(dc,x,y); };
  BOOL QueryAbort(int f) { return ::QueryAbort(dc,f); };
  #endif
  int SaveDC(void) { return ::SaveDC(dc); };
  BOOL RestoreDC(int n) { return ::RestoreDC(dc,n); };
  UINT SetBoundsRect(const Rect &r,UINT flags) { return ::SetBoundsRect(dc,r.GetRectC(),flags); };
  UINT GetBoundsRect(Rect &r,UINT flags) { return ::GetBoundsRect(dc,r.GetRect(),flags); };
  int GetDeviceCaps(int f) { return ::GetDeviceCaps(dc,f); };
  int SetMapMode(int m) { return ::SetMapMode(dc, m); };
  int GetMapMode(void) { return ::GetMapMode(dc); };

  BOOL DPtoLP(POINT FAR *p,int n) { return ::DPtoLP(dc,p,n); };
  BOOL LPtoDP(POINT FAR *p,int n) { return ::LPtoDP(dc,p,n); };
  COLORREF GetNearestColor(COLORREF c) { return ::GetNearestColor(dc,c); };
/* Should we have a GDIOBJ object? */
  HGDIOBJ SelectObject(HGDIOBJ obj) { return ::SelectObject(dc,obj); };
/* Omitted EnumObjects... */

  BOOL GetBrushOrg(POINT FAR *p) { return ::GetBrushOrgEx(dc,p); };
  HPALETTE SelectPalette(HPALETTE pal,BOOL f) { return ::SelectPalette(dc,pal,f); };
  UINT RealizePalette(void) { return ::RealizePalette(dc); };
  int UpdateColors(void) { return ::UpdateColors(dc); };
  UINT GetSystemPaletteEntries(UINT a,UINT b,PALETTEENTRY FAR *ent) { return ::GetSystemPaletteEntries(dc,a,b,ent); };
  UINT GetSystemPaletteUse(void) { return ::GetSystemPaletteUse(dc); };
  UINT SetSystemPaletteUse(UINT f) { return ::SetSystemPaletteUse(dc,f); };
  int SelectClipRgn(HRGN region) { return ::SelectClipRgn(dc,region); };
  int GetClipBox(Rect &r) { return ::GetClipBox(dc,r.GetRect()); };
  int IntersectClipRect(int a,int b,int c,int d) { return ::IntersectClipRect(dc,a,b,c,d); };
  int OffsetClipRgn(int x,int y) { return ::OffsetClipRgn(dc,x,y); };
  int ExcludeClipRect(int a,int b,int c,int d) { return ::ExcludeClipRect(dc,a,b,c,d); };
  BOOL PtVisible(int x,int y) { return ::PtVisible(dc,x,y); };
  BOOL PtVisible(const POINT FAR *p) { return ::PtVisible(dc,p->x,p->y); };
  BOOL RectVisible(const Rect& r) { return ::RectVisible(dc,r.GetRectC()); };


  BOOL GetCurrentPosition(POINT FAR *pt) { return ::GetCurrentPositionEx(dc,pt); };
  BOOL LineTo(int x,int y) { return ::LineTo(dc,x,y); };
  BOOL Polyline(const POINT FAR * p,int n) { return ::Polyline(dc,p,n); };
  BOOL Rectangle(int a,int b,int c,int d) { return ::Rectangle(dc,a,b,c,d); };
  BOOL Rectangle(const Rect &r) { return ::Rectangle(dc,r.Left(),r.Top(),r.Right(),r.Bottom()); };
  BOOL Rectangle(const RECT FAR *r) { return ::Rectangle(dc,r->left,r->top,r->right,r->bottom); };
  BOOL RoundRect(int a,int b,int c,int d,int e,int f) { return ::RoundRect(dc,a,b,c,d,e,f); };
  BOOL Ellipse(int a,int b,int c,int d) { return ::Ellipse(dc,a,b,c,d); };
  BOOL Ellipse(const RECT FAR *r) { return ::Ellipse(dc,r->left,r->top,r->right,r->bottom); };
  BOOL Arc(int a,int b,int c,int d,int e,int f,int g,int h) { return ::Arc(dc,a,b,c,d,e,f,g,h); };
  BOOL Chord(int a,int b,int c,int d,int e,int f,int g,int h) { return ::Chord(dc,a,b,c,d,e,f,g,h); };
  BOOL Pie(int a,int b,int c,int d,int e,int f,int g,int h) { return ::Pie(dc,a,b,c,d,e,f,g,h); };
  BOOL Polygon(const POINT FAR *p,int n) { return ::Polygon(dc,p,n); };
  BOOL PolyPolygon(const POINT FAR *p,int FAR *n1,int n2) { return ::PolyPolygon(dc,p,n1,n2); };
  int SetPolyFillMode(int n) { return ::SetPolyFillMode(dc,n); };
  int GetPolyFillMode(void) { return ::GetPolyFillMode(dc); };
  BOOL FloodFill(int x,int y,COLORREF c) { return ::FloodFill(dc,x,y,c); };
  BOOL FloodFill(int x,int y,COLORREF c,UINT n) { return ::ExtFloodFill(dc,x,y,c,n); };
  BOOL FillRgn(HRGN r,HBRUSH b) { return ::FillRgn(dc,r,b); };
  BOOL FrameRgn(HRGN r,HBRUSH b,int x,int y) { return ::FrameRgn(dc,r,b,x,y); };
  BOOL InvertRgn(HRGN r) { return ::InvertRgn(dc,r); };
  BOOL PaintRgn(HRGN r) { return ::PaintRgn(dc,r); };
  int FillRect(const Rect &r,HBRUSH b) { return ::FillRect(dc,r.GetRectC(),b); };
  int FrameRect(const Rect &r,HBRUSH b) { return ::FrameRect(dc,r.GetRectC(),b); };
  void InvertRect(const Rect &r) { ::InvertRect(dc,r.GetRectC()); };
  void DrawFocusRect(const Rect r) { ::DrawFocusRect(dc,r.GetRectC()); };
  BOOL TextOut(int x,int y,LPSTR text,int ct) {return ::TextOut(dc,x,y,text,ct); };
  BOOL TextOut(int x,int y,LPSTR text) { return ::TextOut(dc,x,y,text,lstrlen(text)); };
/* Defaults?? */
  BOOL TextOut(int x,int y,UINT p,const Rect &r,LPCSTR s,UINT l,int FAR *q) { return ::ExtTextOut(dc,x,y,p,r.GetRectC(),s,l,q); };
  LONG TabbedTextOut(int x,int y,LPCSTR s,int a, int b,int FAR *t,int n) { return ::TabbedTextOut(dc,x,y,s,a,b,t,n); };

  DWORD GetTabbedTextExtent(LPCSTR s,int a,int b,int FAR *t) { return ::GetTabbedTextExtent(dc,s,a,b,t); };
  DWORD GetTextExtentPoint(LPCSTR s, int l,SIZE FAR *sz) { return ::GetTextExtentPoint(dc,s,l,sz); };
  int DrawText(LPCSTR s,int n,Rect &r,UINT f) { return ::DrawText(dc,s,n,r.GetRect(),f); };
/* Ommitted GrayString */
  BOOL GetCharWidth(UINT a,UINT b,int FAR *c) { return ::GetCharWidth(dc,a,b,c); };
  COLORREF SetTextColor(COLORREF c) { return ::SetTextColor(dc,c); };
  COLORREF GetTextColor(void) { return ::GetTextColor(dc); };
  COLORREF SetBkColor(COLORREF c) { return ::SetBkColor(dc,c); };
  COLORREF GetBkColor(void) { return ::GetBkColor(dc); };
  int SetBkMode(int f) { return ::SetBkMode(dc,f); };
  int GetBkMode(void) { return ::GetBkMode(dc); };
  UINT SetTextAlign(UINT f) { return ::SetTextAlign(dc,f); };
  UINT GetTextAlign(void) { return ::GetTextAlign(dc); };
  int SetTextCharacterExtra(int x) { return ::SetTextCharacterExtra(dc,x); };
  int GetTextCharacterExtra(void) { return ::GetTextCharacterExtra(dc); };
  int SetTextJustification(int a,int b) { return ::SetTextJustification(dc,a,b); };
  DWORD SetMapperFlags(DWORD f) { return ::SetMapperFlags(dc,f); };
  int GetTextFace(int n,LPSTR s) { return ::GetTextFace(dc,n,s); };

  BOOL GetAspectRatioFilter(SIZE FAR *s) { return ::GetAspectRatioFilterEx(dc,s); };
  BOOL GetTextMetrics(TEXTMETRIC FAR *tm) { return ::GetTextMetrics(dc,tm); };
  WORD GetOutlineTextMetrics(UINT n,OUTLINETEXTMETRIC FAR *o) { return ::GetOutlineTextMetrics(dc,n,o); };
  int EnumFontFamilies(LPCSTR s,FONTENUMPROC ep,LPSTR l) { return ::EnumFontFamilies(dc,s,ep,(LCAST)l); };
  int EnumFonts(LPCSTR s,OLDFONTENUMPROC ep,LPSTR l) { return ::EnumFonts(dc,s,ep,(LCAST)l); };
  DWORD GetFontData(DWORD a,DWORD b,void FAR *c,DWORD d) { return ::GetFontData(dc,a,b,c,d); };
  DWORD GetGlyphOutline(UINT a,UINT b,GLYPHMETRICS FAR *gm,DWORD c,void FAR *d,const MAT2 FAR *m)
    { return ::GetGlyphOutline(dc,a,b,gm,c,d,m); };
  BOOL GetCharABCWidths(UINT a,UINT b,ABC FAR *abc) { return ::GetCharABCWidths(dc,a,b,abc); };
  int GetKerningPairs(int a,KERNINGPAIR FAR *kp) { return ::GetKerningPairs(dc,a,kp); };
/* Should we have a bitmap object? */
  HBITMAP CreateCompatibleBitmap(int a,int b) { return ::CreateCompatibleBitmap(dc,a,b); };
  HBITMAP CreateDiscardableBitmap(int a,int b) { return ::CreateDiscardableBitmap(dc,a,b); };
  HBITMAP CreateDIBitmap(BITMAPINFOHEADER FAR *bi,DWORD a,const void FAR *b,BITMAPINFO FAR *bmi,UINT c)
    { return ::CreateDIBitmap(dc,bi,a,b,bmi,c); };
  BOOL BitBlt(int x,int y,int x1,int y1,DC &dc1,int x2,int y2,DWORD f)
    {
    return ::BitBlt(dc,x,y,x1,y1,dc1.GetHDC(),x2,y2,f);
    };
  BOOL PatBlt(int x,int y,int x1,int y1,DWORD f) { return ::PatBlt(dc,x,y,x1,y1,f); };
  BOOL StretchBlt(int x,int y,int x1,int y1,DC &dc1,int x2,int y2,int x3,int y3,DWORD f)
    {
    return ::StretchBlt(dc,x,y,x1,y1,dc1.GetHDC(),x2,y2,x3,y3,f);
    };
  int StretchDIBits(int x,int y,int x1,int y1,int x2,int y2,int x3,int y3,
     const VOID FAR *a,LPBITMAPINFO bi,UINT c,DWORD f)
     {
     return ::StretchDIBits(dc,x,y,x1,y1,x2,y2,x3,y3,a,bi,c,f);
     };
  COLORREF SetPixel(int x,int y,COLORREF c) { return ::SetPixel(dc,x,y,c); };
  COLORREF GetPixel(int x,int y) { return ::GetPixel(dc,x,y); };
  int SetStretchBltMode(int f) { return ::SetStretchBltMode(dc,f); };
  int GetStretchBltMode(void) { return ::GetStretchBltMode(dc); };
  int SetROP2(int rop) { return ::SetROP2(dc,rop); };
  int GetROP2(void) { return ::GetROP2(dc); };
  int SetDIBits(HBITMAP bm,UINT a,UINT b,const void FAR *bits,BITMAPINFO FAR *bi,UINT c)
    {
    return ::SetDIBits(dc,bm,a,b,bits,bi,c);
    };
  int GetDIBits(HBITMAP bm,UINT x,UINT y,void FAR *bits,BITMAPINFO FAR *bi,UINT c)
    {
    return ::GetDIBits(dc,bm,x,y,bits,bi,c);
    };
  int SetDIBitsToDevice(int a,int b,int c,int d,int e,int f,UINT g,UINT h,VOID FAR *bits,BITMAPINFO FAR *bi,UINT i)
    {
    return ::SetDIBitsToDevice(dc,a,b,c,d,e,f,g,h,bits,bi,i);
    };
  BOOL PlayMetaFile(HMETAFILE mf) { return ::PlayMetaFile(dc,mf); };
  void PlayMetaFileRecord(HANDLETABLE FAR *ht,METARECORD FAR *mr,UINT f) { ::PlayMetaFileRecord(dc,ht,mr,f); };
  BOOL EnumMetaFile(HMETAFILE mf,MFENUMPROC p,LPARAM l) { return ::EnumMetaFile(dc,mf,p,l); };
/* Move to printDC object??? */
  int StartDoc(DOCINFO FAR *d) { return ::StartDoc(dc,d); };
  int StartPage(void) { return ::StartPage(dc); };
  int EndPage(void) { return ::EndPage(dc); };
  int EndDoc(void) { return ::EndDoc(dc); };
  int AbortDoc(void) { return ::AbortDoc(dc); };
  int SetAbortProc(ABORTPROC ap) { return ::SetAbortProc(dc,ap); };
  int Escape(int a,int b,LPCSTR s,void FAR *d) { return ::Escape(dc,a,b,s,d); };
  int ExcludeUpdateRgn(HWND w) { return ::ExcludeUpdateRgn(dc,w); };
  BOOL ScrollDC(int a,int b,const Rect &r,const Rect &r1,HRGN rg,Rect &r2)
    {
    return ::ScrollDC(dc,a,b,r.GetRectC(),r1.GetRectC(),rg,r2.GetRect());
    };
  BOOL DrawIcon(int x,int y,HICON icon) { return ::DrawIcon(dc,x,y,icon); };
  };

#endif
