#include <windows.h>
#include <commdlg.h>
#include <string.h>
#include <stdlib.h>

extern HANDLE hInst;

/* Generic implemntation of file browse button
  parent=your window or dialog
  w=edit control inside parent to get name
  title=file open dialog title
  filter=file open dialog filter (see COMMDLG docs) */
int browse_file(HWND parent,HWND w,char *title,char *filter)
  {
  char fn[_MAX_PATH];
  int rv;
  SendMessage(w,WM_GETTEXT,_MAX_PATH,(DWORD)fn);
  if (!(rv=get_file(parent,fn,_MAX_PATH,title,filter,FALSE)))
    SendMessage(w,WM_SETTEXT,0,(DWORD)fn);
  return rv;
  }

/* Get a file name */
int get_file(HWND parent,char *fn,int sz,char *title,char *filter,BOOL flag)
  {
  OPENFILENAME of;
  char ft[_MAX_PATH],dir[_MAX_PATH],*p;
  strcpy(dir,fn);
  p=strrchr(dir,'\\');
  if (p) *p='\0'; else *dir='\0';
  memset(&of,0,sizeof(of));
  of.lStructSize=sizeof(of);
  of.hwndOwner=parent;
  of.hInstance=hInst;
  of.lpstrFilter=filter;
  of.nFilterIndex=1;
  of.lpstrFile=fn;
  of.lpstrFileTitle=ft;
  of.nMaxFile=sz;
  of.nMaxFileTitle=_MAX_PATH;
  of.lpstrTitle=title;
  of.lpstrInitialDir=dir;
  if (flag)
    {
    of.Flags=OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT;
    if (!GetSaveFileName(&of)) return 1;
    }
  else
    {
    of.Flags=OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
    if (!GetOpenFileName(&of)) return 1;
    }
  return 0;
  }


