/* Application object -- Williams */
#ifndef _APP_H
#define _APP_H

#include <windows.h>
#include "window.h"

class APP
  {
  protected:
  static HICON deficon;  // default icon for windows
  HINSTANCE hInst,prev;
  LPSTR cmdline;
  int show;
  public:
  Window *mainwin;       // main window
  HINSTANCE GethInstance(void) { return hInst; };
  APP(HINSTANCE hi,HINSTANCE pi,LPSTR cmd,int shw);
  ~APP();
  static APP *app;      // pointer to one and only app obj
  virtual BOOL Init(void);
  int Run(void);
  HICON GetIcon(void) { return deficon; };
  HICON LoadIcon(LPSTR id) { return ::LoadIcon(hInst,id); };
  HICON LoadIcon(int n) { return ::LoadIcon(hInst,MAKEINTATOM(n)); };
  HICON LoadSysIcon(int id) { return ::LoadIcon(NULL,MAKEINTATOM(id)); };
  HICON CreateIcon(int a,int b,BYTE c,BYTE d,const unsigned char FAR *e,const unsigned char FAR *f)
         {
         return ::CreateIcon(hInst,a,b,c,d,e,f);
    };
  HCURSOR LoadCursor(LPSTR id) { return ::LoadCursor(hInst,id); };
  HCURSOR LoadCursor(int n) { return ::LoadCursor(hInst,MAKEINTATOM(n)); };
  HCURSOR LoadSysCursor(int id) { return ::LoadCursor(NULL,MAKEINTATOM(id)); };
  HCURSOR CreateCursor(int a,int b,unsigned char c,unsigned char d, const unsigned char FAR *e, const unsigned char FAR *f)
    {
    return ::CreateCursor(hInst,a,b,c,d,e,f);
    };
  HRSRC FindResource(LPCSTR s,LPCSTR s1) { return ::FindResource(hInst,s,s1); };
  HRSRC FindResource(int n,LPCSTR s1) { return ::FindResource(hInst,MAKEINTATOM(n),s1); };
  HGLOBAL LoadResource(HRSRC r) { return ::LoadResource(hInst,r); };
  DWORD SizeofResource(HRSRC r) { return ::SizeofResource(hInst,r); };
#if defined(_WIN32) || defined(__WIN32__)
#else
  int AccessResource(HRSRC r) { return ::AccessResource(hInst,r); };
  HGLOBAL AllocResource(HRSRC r,DWORD d) { return ::AllocResource(hInst,r,d); };
#endif
  int LoadString(UINT n,LPSTR s,int l) { return ::LoadString(hInst,n,s,l); };
  HBITMAP LoadBitmap(LPCSTR s) { return ::LoadBitmap(hInst,s); };
  HBITMAP LoadBitmap(int n) { return ::LoadBitmap(hInst,MAKEINTATOM(n)); };
  HACCEL LoadAccelerators(LPCSTR s) { return ::LoadAccelerators(hInst,s); };
  HACCEL LoadAccelerators(int n) { return ::LoadAccelerators(hInst,MAKEINTATOM(n)); };
  HMENU LoadMenu(LPCSTR s) { return ::LoadMenu(hInst,s); };
  HMENU LoadMenu(int n) { return ::LoadMenu(hInst,MAKEINTATOM(n)); };
  };



#endif
