unit Oldmain;

interface

  uses
    SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
    Controls, Forms, Dialogs, StdCtrls, FileCtrl, Buttons,
    ColorGrd, IconList;

  type
    TFrmMain = class(TForm)
      PnlNavigator : TPanel;
      PnlIcons     : TPanel;
      LstDirs      : TDirectoryListBox;
      CbxDrives    : TDriveComboBox;
      LstIcons     : TListBox;
      LstFiles     : TFileListBox;
      procedure CbxDrivesChange( Sender : TObject );
      procedure LstDirsChange( Sender : TObject );
      procedure BtnExitClick( Sender : TObject );
      procedure BtnHelpClick( Sender : TObject );
      procedure LstIconsDrawItem( Control : TWinControl;
                                  Index : Integer;
                                  Rect : TRect;
                                  State : TOwnerDrawState );
    procedure FormCreate(Sender: TObject);
    private
      { Private declarations }
    public
      { Public declarations }
    end;

  var
    FrmMain : TFrmMain;

implementation

{$R *.DFM}

  procedure TFrmMain.CbxDrivesChange( Sender : TObject );
  begin
    LstDirs.Drive := CbxDrives.Drive;
  end; {= TFrmMain.CbxDrivesChange =}


  procedure TFrmMain.LstDirsChange( Sender : TObject );
  begin
    LstFiles.Directory := LstDirs.Directory;
    LstIcons.Items     := LstFiles.Items;
  end; {= TFrmMain.LstDirsChange =}


  procedure TFrmMain.BtnExitClick( Sender : TObject );
  begin
    Close;
  end; {= TFrmMain.BtnExitClick =}


  procedure TFrmMain.BtnHelpClick( Sender : TObject );
  begin
    MessageDlg( 'On-line help is not yet available',
                mtInformation, [ mbOK ], 0 );
  end; {= TFrmMain.BtnHelpClick =}


  procedure TFrmMain.LstIconsDrawItem( Control : TWinControl;
                                       Index : Integer;
                                       Rect : TRect;
                                       State : TOwnerDrawState );
  var
    Icon : TIcon;
  begin
    Icon := TIcon.Create;
    with LstIcons do
    begin
      Canvas.FillRect( Rect );   { Clear area for icon and text }
      Icon.LoadFromFile( LstFiles.Directory + '\' +
                         Items.Strings[ Index ] );
               { The Canvas.Draw method knows how to draw icons }
      Canvas.Draw( Rect.Left + 4, Rect.Top + 4, Icon );
      Canvas.TextOut( Rect.Left + 40, Rect.Top + 12,
                      Items.Strings[ Index ] );
    end; { with }
    Icon.Destroy;                                    { Clean Up }
  end; {= TFrmMain.LstIconsDrawItem =}

  procedure TFrmMain.FormCreate(Sender: TObject);
  begin
    LstIcons.Items := LstFiles.Items;
  end;

end.
