unit Mainform;

interface

  uses
    SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
    Controls, Forms, Dialogs, StdCtrls, FileCtrl, Buttons,
    ColorGrd, IconList, ClipBrd;

  type
    TFrmMain = class( TForm )
      PnlNavigator : TPanel;
      PnlIconList  : TPanel;
      LstDirs      : TDirectoryListBox;
      CbxDrives    : TDriveComboBox;
      LstIcons     : TIconListBox;
      ScrCols      : TScrollBar;
      LblColumns   : TLabel;
      Label1       : TLabel;
      BtnExit      : TButton;
      BtnCopy      : TButton;
      procedure CbxDrivesChange( Sender : TObject );
      procedure LstDirsChange( Sender : TObject );
      procedure BtnExitClick( Sender : TObject );
      procedure ScrColsChange( Sender : TObject );
      procedure BtnCopyClick( Sender : TObject );
    private
      { Private declarations }
    public
      { Public declarations }
    end;

  var
    FrmMain: TFrmMain;

implementation

{$R *.DFM}


  procedure TFrmMain.CbxDrivesChange(Sender: TObject);
  begin
    LstDirs.Drive := CbxDrives.Drive;
  end; {= TFrmMain.CbxDrivesChange =}


  procedure TFrmMain.LstDirsChange(Sender: TObject);
  begin
    LstIcons.Directory := LstDirs.Directory;
  end; {= TFrmMain.LstDirsChange =}


  procedure TFrmMain.BtnExitClick(Sender: TObject);
  begin
    Close;
  end; {= TFrmMain.BtnExitClick =}


  procedure TFrmMain.ScrColsChange(Sender: TObject);
  begin
    LstIcons.Columns := ScrCols.Position;
    LblColumns.Caption := IntToStr( ScrCols.Position );
  end; {= TFrmMain.ScrColsChange =}


  procedure TFrmMain.BtnCopyClick(Sender: TObject);
  var
    Icon   : TIcon;
    Bitmap : TBitmap;
  begin
    Icon   := TIcon.Create;                  { Create Temp Icon }
    Bitmap := TBitmap.Create;              { Create Temp Bitmap }

    try
      with LstIcons do  { Read icon file specified by ItemIndex }
        Icon.LoadFromFile( Directory + '\' +
                           Items.Strings[ ItemIndex ] );
                                { Make Bitmap same size as Icon }
      Bitmap.Width := Icon.Width;
      Bitmap.Height := Icon.Height;

           { Draw Icon on Bitmap so we can copy it to Clipboard }
      Bitmap.Canvas.Draw( 0, 0, Icon );
                                     { Copy Bitmap to Clipboard }
      Clipboard.AsPicture.Graphic := Bitmap;

    finally
      Icon.Destroy;                           { Always Clean Up }
      Bitmap.Destroy;
    end;
  end; {= TFrmMain.BtnCopyClick =}

end.
