unit IconList;

interface

  uses
    WinTypes, StdCtrls, Classes, FileCtrl;

  type
    TIconListBox = class( TFileListBox )
    protected
      procedure DrawItem( Index : Integer; Rect : TRect;
                          State : TOwnerDrawState ); override;
    public
      constructor Create( AOwner : TComponent ); override;
    published
      property Columns;
    end;

  procedure Register;


implementation

  uses
    Graphics;

  {==========================}
  {== TIconListBox Methods ==}
  {==========================}

  constructor TIconListBox.Create( AOwner : TComponent );
  begin
    inherited Create( AOwner );
    Mask       := '*.ICO';               { Show Only Icon Files }
    ItemHeight := 40;        { List Box with Fixed Height of 40 }
  end; {= TIconListBox.Create =}


  procedure TIconListBox.DrawItem( Index : Integer; Rect : TRect;
                                   State : TOwnerDrawState );
  var
    Icon : TIcon;
  begin
    Icon := TIcon.Create;               { Create Temporary Icon }

    try
      Canvas.FillRect( Rect ); { Clear the Region for List Item }
      Icon.LoadFromFile( Directory + '\' + Items.Strings[ Index ] );
                               { Paint the Icon in the List Box }
      Canvas.Draw( Rect.Left + 4, Rect.Top + 4, Icon );
                               { Display file name next to icon }
      Canvas.TextOut( Rect.Left + 40, Rect.Top + 12,
                      Items.Strings[ Index ] );
    finally
      Icon.Destroy;       { Make sure to destroy Temporary Icon }
    end; { try..finally }
  end; {= TIconListBox.DrawItem =}



  procedure Register;
  begin
    RegisterComponents( 'System', [ TIconListBox ] );
  end; {= Register =}

end.
