/*************************************************
 *                                               *
 * INIEDIT Header File -- Williams               *
 *                                               *
 *************************************************/
#include <windows.h>
#include <commdlg.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "cwdlg.h"
#include "iniedit.h"
#ifdef USE3D
#include <ctl3d.h>
#endif

HANDLE hInst;

/* Data */
LPSTR sections[256];
LPSTR keys[256];
/* Temporary */
char tline[1024];

/* File names */
char fn[256];
char helpfn[256];

/* Selections */
char sel_section[256];
char sel_key[256];
/* Current value */
char value[256];

void setsections(char *fn,LPSTR FAR *list);
void setkeys(char *fn,char *sec,LPSTR FAR *list);
int browse_file(HWND parent,HWND w ,char *title,
  char *filter);


/* Runs when browse button activated */
BOOL WINAPI _export brwsfunc(HWND dlg,UINT wParam,UINT hw,
  UINT lw,UINT FAR *sub)
  {
  /* do browse code */
  if (!browse_file(dlg,GetDlgItem(dlg,FILENAME),
    "Select INI File",
    "INI Files (*.ini)\0*.INI\0All Files (*.*)\0*.*\0"))
     {
     char *p;
  /* set helpfile name */
     cw_DlgTransferID(dlg,FALSE,FILENAME);
     lstrcpy(helpfn,fn);
     p=strchr(helpfn,'.');
     if (!p)
       {
       lstrcat(helpfn,".INI");
       p=strchr(helpfn,'.');
       }
     if (lstrlen(p)==4)
       p[3]='H';
     else
       lstrcat(p,"H");
     *sel_section='\0';
     *sel_key='\0';
     *value='\0';
/* Set up */
     setsections(fn,sections);
     setkeys(fn,sel_section,keys);
     cw_DlgTransfer(dlg,TRUE);
     SendDlgItemMessage(dlg,HELPTEXT,WM_SETTEXT,0,
       (DWORD)"Please select a section and a key");
     }
  return TRUE;
  }

/* Write data to INI file, if needed */
void commit(HWND dlg)
  {
  if (!*sel_section||!*sel_key) return;
  if (SendDlgItemMessage(dlg,VALUE,EM_GETMODIFY,0,0))
    {
    WritePrivateProfileString(sel_section,sel_key,
      value,fn);
/* If WIN.INI changed, tell everyone */
    if (!stricmp("WIN.INI",fn+lstrlen(fn)-7))
       SendMessage(HWND_BROADCAST,WM_WININICHANGE,
         0,(DWORD)sel_section);
    }
  SendDlgItemMessage(dlg,VALUE,EM_SETMODIFY,0,0);
  }


/* The OK button runs this function */
BOOL WINAPI _export okfunc(HWND dlg,UINT wParam,UINT hw,
  UINT lw,UINT FAR *sub)
  {
  commit(dlg);
  EndDialog(dlg,0);
  return TRUE;
  }

/* When the section changes, this function runs */
BOOL WINAPI _export secchange(HWND dlg,UINT wParam,
  UINT hw,UINT lw,UINT FAR *sub)
  {
/* during CBN_SELCHANGE, the sel is not in the edit! */
  if (hw==CBN_SELCHANGE)
#ifdef _WIN32
    PostMessage(dlg,WM_COMMAND,
      MAKELONG(wParam,CBN_EDITCHANGE),lw);
#else
    PostMessage(dlg,WM_COMMAND,
      wParam,MAKELONG(lw,CBN_EDITCHANGE));
#endif
  if (hw==CBN_EDITCHANGE)
    {
    cw_DlgTransferID(dlg,FALSE,VALUE);
    commit(dlg);
    cw_DlgTransferID(dlg,FALSE,SECTION_CB);
    setkeys(fn,sel_section,keys);
    *sel_key='\0';
    *value='\0';
    cw_DlgTransferID(dlg,TRUE,VALUE_CB);
    cw_DlgTransferID(dlg,TRUE,VALUE);
    SendDlgItemMessage(dlg,HELPTEXT,WM_SETTEXT,
      0,(DWORD)"Please select a key");
    }
  return TRUE;
  }

/* This function runs when the value changes */
BOOL WINAPI _export valchange(HWND dlg,UINT wParam,
  UINT hw,UINT lw,UINT FAR *sub)
  {
  if (hw==CBN_SELCHANGE)
#ifdef _WIN32
    PostMessage(dlg,WM_COMMAND,
      MAKELONG(wParam,CBN_EDITCHANGE),lw);
#else
    PostMessage(dlg,WM_COMMAND,
      wParam,MAKELONG(lw,CBN_EDITCHANGE));
#endif

  if (hw==CBN_EDITCHANGE)
    {
    cw_DlgTransferID(dlg,FALSE,VALUE);
    commit(dlg);
    cw_DlgTransferID(dlg,FALSE,VALUE_CB);
    GetPrivateProfileString(sel_section,sel_key,"",
      value,sizeof(value),fn);
/* Get help */
    GetPrivateProfileString(sel_section,sel_key,
      "",tline,sizeof(tline),helpfn);
    if (!*tline)
      GetPrivateProfileString(sel_section,"*",
      "<No help available>",
      tline,sizeof(tline),helpfn);
    SendDlgItemMessage(dlg,HELPTEXT,WM_SETTEXT,
      0,(DWORD)tline);
    cw_DlgTransferID(dlg,TRUE,VALUE);
    }
  return TRUE;
  }

/* Delete item */
BOOL WINAPI _export delkey(HWND dlg,UINT wParam,UINT hw,
  UINT lw,UINT FAR *sub)
  {
  if (MessageBox(dlg,"Delete key?",
    "Confirm",MB_YESNO|MB_ICONHAND)==IDYES)
    {
    WritePrivateProfileString(sel_section,sel_key,
      NULL,fn);
    *value=*sel_key='\0';
    setkeys(fn,sel_section,keys);
    cw_DlgTransfer(dlg,TRUE);
    }
  return TRUE;
  }



/* Dialog data template */
DLGDATA(dlgbuf)
DLGITEM(FILENAME,sizeof(fn),fn)
DLGITEM(IDBROWSE,CWDLG_PBUTTON,brwsfunc)
DLGITEM(IDOK,CWDLG_PBUTTONX,okfunc)
DLGITEM(IDCANCEL,CWDLG_PBUTTONX,okfunc)  // close box
DLGITEM(SECTION_CB,CWDLG_CBINIT,sections)
DLGITEM(SECTION_CB,sizeof(sel_section),sel_section)
DLGITEM(SECTION_CB,CWDLG_PBUTTON,secchange)
DLGITEM(VALUE_CB,CWDLG_CBINIT,keys)
DLGITEM(VALUE_CB,sizeof(sel_key),sel_key)
DLGITEM(VALUE_CB,CWDLG_PBUTTON,valchange)
DLGITEM(VALUE,sizeof(value),value)
DLGITEM(IDDELETE,CWDLG_PBUTTONX,delkey)
DLGEND;



/* Set sections from file name */
void setsections(char *fn,LPSTR FAR *list)
  {
  FILE *f;
  int i=0;
  if (list[0]) free((void *)list[0]);
  list[0]=NULL;
  if (!*fn) return;
  f=fopen(fn,"r");
  if (!f) return;
  while (fgets(tline,sizeof(tline),f))
    {
    int idx=0;
    char *p;
    while (isspace(tline[idx])) idx++;
/* ignore non sections */
    if (tline[idx]!='[') continue;
    p=strchr(tline,']');
    if (p) *p='\0';
    list[i++]=(LPSTR)strdup(tline+idx+1);
    if (list[i]) free((void *)list[i]);
    list[i]=NULL;
    }
  fclose(f);
  }

/* Set keys, given file name & section name */
void setkeys(char *fn,char *sec,LPSTR FAR *list)
  {
  FILE *f;
  int i=0;
  int insection=0;
  if (list[0]) free((void *)list[0]);
  list[0]=NULL;
  if (!*fn) return;
  f=fopen(fn,"r");
  if (!f) return;
  while (fgets(tline,sizeof(tline),f))
    {
    int idx=0;
    char *p;
    while (isspace(tline[idx])) idx++;
    if (tline[idx]==';'||tline[idx]=='\0') continue;
/* If in named section pick up keys */
    if (insection)
      {
      if (tline[idx]=='[')  /* stop at next section */
        insection=0;
      else
        {
        p=strchr(tline,'=');
        if (p) *p='\0';
        list[i++]=strdup(tline+idx);
        if (list[i]) free((void *)list[i]);
        list[i]=NULL;
        }
      }
/* ignore non-sections */
    if (tline[idx]!='[') continue;
    p=strchr(tline,']');
    if (p) *p='\0';
    if (stricmp(tline+idx+1,sec)) continue;
    insection=1;
    }
  fclose(f);
  }



/* Main entry point */
int PASCAL WinMain(HANDLE hInstin, HANDLE prev,
  LPSTR cmdline, int show)
  {
  hInst=hInstin;
#ifdef USE3D
  Ctl3dRegister(hInst);
#endif
  if (!prev) cdlg_Init(hInst,LoadIcon(hInst,
    MAKEINTRESOURCE(MAINICON)));
/* Show dialog box -- No callback! */
  cw_DialogBox(hInst,MAKEINTRESOURCE(MAINDLG),
    NULL,NULL,dlgbuf);
#ifdef USE3D
  Ctl3dUnregister(hInst);
#endif
  return FALSE;
  }


/* Generic implementation of file browse button
  parent=your window or dialog
  w=edit control inside parent to get name
  title=file open dialog title
  filter=file open dialog filter (see COMMDLG docs) */
int browse_file(HWND parent,HWND w ,char *title,char *filter)
  {
  OPENFILENAME of;
  char fn[_MAX_PATH],ft[_MAX_PATH],dir[_MAX_PATH],*p;
  SendMessage(w,WM_GETTEXT,_MAX_PATH,(DWORD)fn);
  strcpy(dir,fn);
  p=strrchr(dir,'\\');
  if (p) *p='\0'; else *dir='\0';
  memset(&of,0,sizeof(of));
  of.lStructSize=sizeof(of);
  of.hwndOwner=parent;
  of.hInstance=hInst;
  of.lpstrFilter=filter;
  of.nFilterIndex=1;
  of.lpstrFile=fn;
  of.lpstrFileTitle=ft;
  of.nMaxFile=of.nMaxFileTitle=_MAX_PATH;
  of.lpstrTitle=title;
  of.lpstrInitialDir=dir;
  of.Flags=OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
  if (!GetOpenFileName(&of)) return 1;
  SendMessage(w,WM_SETTEXT,0,(DWORD)fn);
  return 0;
  }
