/*************************************************
 *                                               *
 * CoolDialog Library Main File -- Williams      *
 *                                               *
 *************************************************/

#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include "cwdlg.h"
#ifdef USE3D
#include <ctl3d.h>
#endif

/* If message cracker not defined, define them --
   assume only 16-bit compiler won't know them */
#ifndef GET_WM_COMMAND_ID
#define GET_WM_COMMAND_ID(w,l) (w)
#define GET_WM_COMMAND_CMD(w,l) HIWORD(l)
#define GET_WM_COMMAND_HWND(w,l) LOWORD(l)
#endif


LONG WINAPI _export cwDlgProc(HWND dlg, UINT msg,
   WPARAM wParam, LPARAM lParam);

/* Empty dialog template */
static DLGITEMS cw_NullCDlgTempv[1] =
  {0, 0, 0  };

/* Return empty dialog template */
LPDLGITEMS WINAPI cw_NullCDlgTemp()
  {
  return cw_NullCDlgTempv;
  }

/* Set up CoolDialog system */
int WINAPI cdlg_Init(HANDLE hInst,HICON icon)
  {
/* Register our private dialog class */
  static WNDCLASS wc={ 0,cwDlgProc,0,
    DLGWINDOWEXTRA+8,NULL,NULL,NULL,
    (HBRUSH)(COLOR_WINDOW+1),NULL,"CoolDialog" };
  wc.hInstance=hInst;
  wc.hIcon=icon;
  return (int)RegisterClass(&wc);
  }


/* Common routine for handing WM_COMMAND */
UINT pbutton(HWND dlg, WPARAM wParam, LPARAM lParam)
  {
  DLGITEMS *ary =(DLGITEMS *)
    GetWindowLong(dlg, DLGWINDOWEXTRA);
  if (!ary)
    return wParam;
/* Scan dialog data template */
  while (ary->id)
      {
      if (ary->id == GET_WM_COMMAND_ID(wParam,lParam) &&
     (ary->typelen == CWDLG_PBUTTON ||
      ary->typelen == CWDLG_PBUTTONX))
       {
       FARPROC f =(FARPROC) ary->value;
       UINT val = 0;
/* Transfer if requested */
       if (ary->typelen == CWDLG_PBUTTONX)
         cw_DlgTransfer(dlg, FALSE);
       if (!f)
         return wParam;
/* Call function and process */
       if (!f(dlg, GET_WM_COMMAND_ID(wParam,lParam),
           GET_WM_COMMAND_CMD(wParam,lParam),
           GET_WM_COMMAND_HWND(wParam,lParam),
           (UINT FAR *)&val))
         return IDCANCEL;
#ifdef _WIN32
       return MAKELONG(val,HIWORD(wParam));
#else
       return val;
#endif
       }
      ary++;
      }
  return wParam;
  }


/* Dialog procedure */
BOOL WINAPI _export cwDlgProc2(HWND dlg, UINT msg,
   WPARAM wParam, LPARAM lParam)
  {
  FARPROC chain =(FARPROC)
    GetWindowLong(dlg, DLGWINDOWEXTRA + 4);
  if (msg == WM_INITDIALOG)
      {
      LONG *array =(LONG *) lParam;
      BOOL rv = TRUE;
#ifdef USE3D
      Ctl3dSubclassDlgEx(dlg, CTL3D_ALL);
#endif
/* Cache away info */
      SetWindowLong(dlg, DLGWINDOWEXTRA + 4,
        (LONG)(chain =(FARPROC) array[1]));
      SetWindowLong(dlg, DLGWINDOWEXTRA, array[0]);
      cw_DlgTransfer(dlg, TRUE);
/* Call user dialog callback, if supplied */
      if (chain)
       {
       rv = chain(dlg, msg, wParam, array[2]);
       if (rv)
         cw_DlgTransfer(dlg, TRUE);
       }
      return rv;
      }
/* If no user callback, handle close */
  if (!chain && msg == WM_CLOSE)
      {
      msg = WM_COMMAND;
#ifdef _WIN32
      wParam=MAKELONG(IDCANCEL,BN_CLICKED);
#else
      wParam = IDCANCEL;
#endif
      }

/* Handle WM_COMMAND */
  if (msg == WM_COMMAND)
      {
      if (wParam = pbutton(dlg, wParam, lParam))
       {
      if (!chain)
        if (wParam == IDOK)
          cw_EndDialog(dlg, 0, TRUE);
        else if (wParam == IDCANCEL)
          EndDialog(dlg, 1);
       }
      else
        return FALSE;     /* pbuttons said abort */
      }
  return chain?chain(dlg, msg, wParam, lParam) : FALSE;
  }


/* Must have this because we need the extra bytes */
LONG WINAPI _export cwDlgProc(HWND dlg, UINT msg,
  WPARAM wParam, LPARAM lParam)
  {
  return DefDlgProc(dlg, msg, wParam, lParam);
  }


/* Transfer from/to control (if id==0, do all) */
void WINAPI cw_DlgTransferID(HWND dlg, BOOL dir,int id)
  {
  DLGITEMS *ary =(DLGITEMS *) GetWindowLong(dlg, DLGWINDOWEXTRA);
  if (!ary)
    return;
  while (ary->id)
      {
      if (id&&ary->id!=id)
        {
        ary++;
        continue;
        }
      if (ary->value)
        {
        if (ary->typelen <= 10)
         {
/* Handle non-string controls */
         switch (ary->typelen)
          {
          case CWDLG_PBUTTON:
          case CWDLG_PBUTTONX:
/* These do not participate in tranfers */
          break;

          case CWDLG_MULTILB:
            {
            int FAR *v=(int FAR *)ary->value;
            if (!v) break;
            if (!dir)
              {
              v[1]=SendDlgItemMessage(dlg,ary->id,
                 LB_GETSELITEMS,v[0],(DWORD)v+2);
              }
            else
              {
              unsigned i;
              HWND lb=GetDlgItem(dlg,ary->id);
              SendMessage(lb,LB_SETSEL,0,-1);
              for (i=0;i<v[1];i++)
                SendMessage(lb,LB_SETSEL,1,v[2+i]);
              }
            }
          break;

          case CWDLG_LBINIT:
            {
            LPSTR FAR *v =(LPSTR FAR *) ary->value;
            LPSTR sv;
            if (!dir)
              break;
            SendDlgItemMessage(dlg, ary->id,
              LB_RESETCONTENT, 0, 0);
            for (sv = *v; sv; sv = *++v)
              SendDlgItemMessage(dlg, ary->id,
                LB_ADDSTRING, 0,(DWORD) sv);
            }
           break;

           case CWDLG_CBINIT:
            {
            LPSTR FAR *v =(LPSTR FAR *) ary->value;
            LPSTR sv;
            if (!dir)
              break;
            SendDlgItemMessage(dlg, ary->id,
              CB_RESETCONTENT, 0, 0);
            for (sv = *v; sv; sv = *++v)
              SendDlgItemMessage(dlg, ary->id,
                CB_ADDSTRING, 0,(DWORD) sv);
            }
           break;

           case CWDLG_BUTTON:
             if (dir)
               SendDlgItemMessage(dlg, ary->id,
                 BM_SETCHECK,*(ary->value) == 'x'
                 || *(ary->value) == 'X', 0);
             else if (SendDlgItemMessage(dlg, ary->id,
               BM_GETCHECK, 0, 0))
               *((LPSTR) (ary->value)) = 'X';
             else
               *((LPSTR) (ary->value)) = ' ';
             break;

           case CWDLG_COMBOBOX:
             if (dir)
               SendDlgItemMessage(dlg, ary->id,
                 CB_SETCURSEL,(int) *(LONG FAR *)
                 ary->value, 0);
             else
              *(LONG FAR *) ary->value =
                SendDlgItemMessage(dlg, ary->id,
                CB_GETCURSEL, 0, 0);
             break;

           case CWDLG_LISTBOX:
             {
             LONG ndx;
             if (dir)
              SendDlgItemMessage(dlg,(int) ary->id,
                LB_FINDSTRINGEXACT,-1,(DWORD)ary->value);
             else
              {
              ndx = SendDlgItemMessage(dlg, ary->id,
                 LB_GETCURSEL, 0, 0);
              SendDlgItemMessage(dlg, (int) ary->id,
                  LB_GETTEXT, ndx, (DWORD)ary->value);
              }
            }
           break;

           case CWDLG_LB:
             if (dir)
               SendDlgItemMessage(dlg, (int) ary->id,
               LB_SETCURSEL,*(LONG FAR *) ary->value, 0);
             else
              *(LONG FAR *) ary->value =
                SendDlgItemMessage(dlg, ary->id,
                LB_GETCURSEL, 0, 0);
             break;

            }
         }
     else  /* All string transfers */
       {
       char cls[33];
       SendDlgItemMessage(dlg, ary->id,
         dir ? WM_SETTEXT : WM_GETTEXT,
         (int) ary->typelen, (DWORD)ary->value);
       if (dir)
         {
/* Set selection for edit controls only */
         GetClassName(GetDlgItem(dlg,ary->id),cls,sizeof(cls));
         if (!lstrcmpi(cls,"Edit"))
           SendDlgItemMessage(dlg,ary->id,
             EM_SETSEL,0,MAKELONG(0,0xFFFF));
         if (!lstrcmpi(cls,"ComboBox"))
           SendDlgItemMessage(dlg,ary->id,
             CB_SETEDITSEL,0,MAKELONG(0,0xFFFF));
         }
       }
     }
    ary++;  /* continue scanning */
    }
  }

/* End dialog and maybe transfer */
void WINAPI cw_EndDialog(HWND dlg, int result, BOOL xfer)
  {
  if (xfer)
    cw_DlgTransfer(dlg, FALSE);
  EndDialog(dlg, result);
  }

/* Set an item in a data template */
BOOL WINAPI cw_DlgSetItem(DLGITEMS FAR * items,
          int id, unsigned tl, LPSTR val)
  {
/* find item and change */
  for (; items && items->id; items++)
      {
      if (items->id == id)
       {
       items->typelen = tl;
       items->value = val;
       return TRUE;
       }
      }
  return FALSE;
  }

/* Create dialog box */
int WINAPI cw_DialogBoxParam(HANDLE hInst,
  LPCSTR tname,HWND parent,DLGPROC cb, LPARAM lParam,
  DLGITEMS FAR * items)
  {
  LONG ary[3];
  int rw;
/* If special call build parameter array */
  if (items)
      {
      ary[0] = (LONG) items;
      ary[1] = (LONG) cb;
      ary[2] = lParam;
/* call real call & pass array */
      rw = DialogBoxParam(hInst, tname, parent,
        cwDlgProc2,(DWORD) ary);
      }
  else
/* call real call */
    rw = DialogBoxParam(hInst, tname, parent, cb, lParam);
  return rw;
  }

/* Same as above (2nd verse same as the first) */
int WINAPI cw_DialogBoxIndirectParam(HANDLE hInst,
  HANDLE temp, HWND parent,DLGPROC cb, LPARAM lParam,
  DLGITEMS FAR * items)
  {
  LONG ary[3];
  int rw;
  if (items)
      {
      ary[0] = (LONG) items;
      ary[1] = (LONG) cb;
      ary[2] = lParam;
      rw = DialogBoxIndirectParam(hInst, temp, parent,
        cwDlgProc2,(DWORD) ary);
      }
  else
    rw = DialogBoxIndirectParam(hInst, temp, parent,
      cb, lParam);
  return rw;
  }



