Global lpSCB As Long

Declare Function OpenSpeech Lib "d:\monologw\fb_spch.dll" (ByVal hWnd%, ByVal mode%, ByVal voiceType As Any) As Long

Declare Function CloseSpeech Lib "d:\monologw\fb_spch.dll" (ByVal lpSCB&) As Integer

Declare Function Say Lib "d:\monologw\fb_spch.dll" (ByVal lpSCB&, ByVal phrase$) As Integer

Function Accent$ (s$)
  ' Marks the accented vowel in a Spanish word
  ' (given as a phoneme string) if not already marked.
  ' Does not add an accent to one-syllable words.

  ' Is the accented vowel marked already? If so, bail out.
  For i% = 1 To Len(s$)
    If InStr("", Mid$(s$, i%, 1)) Then
      Accent$ = s$
      Exit Function
    End If
  Next i%

  ' Make i% point to the last place where the
  ' accented vowel could be
  If InStr("aeiou", Right$(s$, 1)) Then
    i% = Len(s$) - 1
  ElseIf InStr("ns", Right$(s$, 1)) Then
    i% = Len(s$) - 2
  Else
    i% = Len(s$)
  End If

  ' Work back until vowel or beginning of word
  ' is actually found
  Do
    If i% < 1 Then Exit Do
      ' because it's a 1-syllable word
    If InStr("aeiou", Mid$(s$, i%, 1)) Then Exit Do
      ' because the accented vowel has been found
    i% = i% - 1
  Loop

  r$ = s$
  If i% >= 1 Then
    ' Accent the vowel that i% points to
    Mid$(r$, i%, 1) = Mid$("", InStr("aeiou", Mid$(s$, i%, 1)), 1)
  End If
 
  Accent$ = r$
End Function

Function Phonemicize$ (s$)
  ' Phonemicization of Spanish.
  ' Written for clarity, not speed.

  Dim prev As String * 1, this As String * 1, foll As String * 1

  r$ = ""   ' will hold result
  t$ = " " + LCase$(s$) + " "
  i = 2
  While i < Len(t$)
    ' Pick out substrings to be examined
    prev = Mid$(t$, i - 1, 1)
    this = Mid$(t$, i, 1)
    foll = Mid$(t$, i + 1, 1)
    first2$ = this + foll

    ' Two-letter combinations.
    ' Each of them increments i an extra time.
    If first2$ = "ch" Then
      p$ = "C":        i = i + 1
    ElseIf first2$ = "ll" Then
      p$ = "y":        i = i + 1
    ElseIf first2$ = "rr" Then
      p$ = "R":        i = i + 1
    ElseIf first2$ = "qu" Then
      p$ = "k":        i = i + 1

    ' Consonants: simple cases
    ElseIf this = "z" Then
      p$ = "s"
    ElseIf this = "h" Then
      p$ = ""
    ElseIf this = "" Then
      p$ = "ny"
    ElseIf this = "v" Then
      p$ = "b"
    ElseIf this = "x" Then
      p$ = "ks"

    ' Consonants influenced by context
    ElseIf this = "c" Then
      If InStr("ei", foll) Then
        p$ = "s"
      Else
        p$ = "k"
      End If
    ElseIf this = "g" And InStr("ei", foll) Then
      p$ = "j"
    ElseIf this = "u" And prev = "g" And InStr("ei", foll) Then
      p$ = ""
    ElseIf this = "m" And foll = " " Then
      p$ = "n"    ' at end of word
    ElseIf this = "r" And prev = " " Then
      p$ = "R"    ' at beginning of word

    ' Semivowels
    ElseIf this = "" Then
      p$ = "w"
    ElseIf this = "y" And prev = " " And foll = " " Then
      p$ = "i"
    ElseIf this = "i" And (InStr("aeo", prev) Or InStr("aeou", foll)) Then
      p$ = "y"
    ElseIf this = "u" And (InStr("aeo", prev) Or InStr("aeio", foll)) Then
      p$ = "w"

    ' Default case
    Else
      p$ = this
    End If

  r$ = r$ + p$
  i = i + 1
  Wend

  Phonemicize$ = r$
End Function

Function Phonetic$ (s$)
  ' Takes a string of Spanish phonemes and
  ' translates to a Monologue(TM) phonetic string
  
  Dim prev As String * 1, this As String * 1, foll As String * 1
  Vowel$ = "aeiou"

  If InStr(",:;.?!", s$) Then
    ' Pass punctuation-mark tokens through unchanged
    Phonetic$ = s$
    Exit Function
  End If

  r$ = "<<~"  ' will hold result
  t$ = " " + s$ + " "
  i% = 2
  While i% < Len(t$)
    ' Pick out substrings to be examined
    prev = Mid$(t$, i% - 1, 1)
    this = Mid$(t$, i%, 1)
    foll = Mid$(t$, i% + 1, 1)

    ' Diphthongs with off-glides
    If this = "a" And foll = "w" Then
      a$ = "AW"
    ElseIf this = "" And foll = "w" Then
      a$ = "'AW"
    ElseIf this = "e" And foll = "y" Then
      a$ = "EY"
    ElseIf this = "" And foll = "y" Then
      a$ = "'EY"
    ElseIf this = "o" And foll = "y" Then
      a$ = "OY"
    ElseIf this = "" And foll = "y" Then
      a$ = "'OY"

    ' Vowels
    ElseIf this = "a" Then
      a$ = "AA"
    ElseIf this = "" Then
      a$ = "'AA"
    ElseIf this = "e" Then
      If InStr(Vowel$ + " ", foll) Then
        a$ = "EHEH"  ' for extra duration
      Else
        a$ = "EH"
      End If
    ElseIf this = "" Then
      a$ = "'EHEH"
    ElseIf this = "i" Then
      a$ = "IY"
    ElseIf this = "" Then
      a$ = "'IY"
    ElseIf this = "o" Then
      a$ = "OW"
    ElseIf this = "" Then
      a$ = "'OW"
    ElseIf this = "u" Then
      If InStr(Vowel$ + " lmnbdg", foll) Then
        a$ = "UW"
      Else
        a$ = "UH"
      End If
    ElseIf this = "" Then
      If InStr(Vowel$ + " lmnbdg", foll) Then
        a$ = "'UW"
      Else
        a$ = "'UH"
      End If

    ' Stop consonants
    ElseIf this = "t" Then
      If foll = "r" And prev <> "w" Then
        a$ = "TX"
      Else
        a$ = "t"
      End If
    ElseIf this = "b" Then
      If InStr(Vowel$ + "lnr", prev) And InStr(Vowel$ + "lmnr", foll) Then
        a$ = "v"
      Else
        a$ = "b"
      End If
    ElseIf this = "d" Then
      If InStr("ln ", prev) Then
        a$ = "d"
      Else
        a$ = "DH"
      End If

    ' Other consonants
    ElseIf this = "n" Then
      If foll = "b" Then
        a$ = "m"
      Else
        a$ = "nn"   ' the extra length helps
      End If
    ElseIf this = "w" Then
      If InStr("e", prev) Then
        a$ = "UW"
      Else
        a$ = "w"
      End If
    ElseIf this = "l" Then
      If InStr(vowels, foll) Then
        a$ = "l"   'This contradicts Spanish phonetics,
      Else         'where L is never velar, but is
        a$ = "LX"  'needed for appropriate timing etc.
      End If
    ElseIf this = "r" Then
      If InStr("o", prev) Then
        a$ = "r"
      ElseIf InStr(vowels, prev) <> 0 And InStr(vowels, foll) <> 0 Then
        a$ = "DX"
      ElseIf InStr(vowels + "ktfbdgy", prev) Then
        a$ = "rDX"
      ElseIf prev = "p" Then
        a$ = "DXr"
      Else
        a$ = "DX"
      End If
    ElseIf this = "R" Then
      If InStr(vowels + "ktfbdgy", prev) Then
        a$ = "r[DXr[DXr"
      ElseIf prev = "p" Then
        a$ = "[DXr[DXr"
      Else
        a$ = "[DXr[DX"
      End If
    ElseIf this = "j" Then
      a$ = "]]h"
    ElseIf this = "s" Then
      If InStr("bdglmnr", foll) Then
        a$ = "z"
      Else
        a$ = "s"
      End If
    ElseIf this = "C" Then
      a$ = "tSH"
    
    Else  ' a few symbols go through unchanged
      a$ = this
    End If

    i% = i% + 1
    r$ = r$ + " " + a$
  Wend
  Phonetic = r$ + " >>"
End Function

