{ UTILS.PAS }
{
Description:  Several miscellaneous routines for Turbo Vision programs.
Author:       Don Taylor
Date:         5 June 1993
Last revised: 10 April 1994 23:15
Application:  IBM PC and compatibles; BP7.0; TV2.0

}

unit Utils;

{--------------------}
     INTERFACE
{--------------------}
uses
 Crt,
 Dos,
 Objects,
 Views,
 Drivers,
 Dialogs;

const
 NormYearSecs = 31536000;  { Number of seconds in 365 day year }
 LeapYearSecs = 31622400;  { Number of seconds in 366 day year }
 SecsInDay    =    86400;  { Number of seconds in a 24 hour day }

function MinutesToLongint(M : Word) : Longint;
function HoursToLongint(H : Word) : Longint;
function DaysToLongint(D : Word) : Longint;
function WeeksToLongint(W : Word) : Longint;
function DateToLongInt(DT : DateTime) : Longint;
function LeapYear(Year : Word) : Boolean;
function Now : Longint;

procedure LongintToDate(LDate : Longint; var DT : DateTime);

{--------------------}
   IMPLEMENTATION
{--------------------}

{--------------------
  MinutesToLongint converts the specified number
  of minutes to seconds as a Longint.
----------------------}
function MinutesToLongint(M : Word) : Longint;
begin
 MinutesToLongint := Longint(M) * 60;
end;  { MinutesToLongint }

{--------------------
  HoursToLongint converts the specified number
  of hours to seconds as a Longint.
----------------------}
function HoursToLongint(H : Word) : Longint;
begin
 HoursToLongint := Longint(H) * 3600;
end; { HoursToLongint }

{--------------------
  DaysToLongint converts the specified number
  of days to seconds as a Longint.
----------------------}
function DaysToLongint(D : Word) : Longint;
begin
 DaysToLongint := Longint(D) * 86400;
end; { DaysToLongint }

{--------------------
  WeeksToLongint converts the specified number
  of weeks to seconds as a Longint.
----------------------}
function WeeksToLongint(W : Word) : Longint;
begin
 WeeksToLongint := Longint(W) * 604800;
end; { WeeksToLongint }

{--------------------
  The DateToLongint function converts a DateTime
  record to a longint whose value is the number
  of seconds that have elapsed since January 1, 1970.
---------------------}
function DateToLongint(DT : DateTime) : Longint;
var
 L      : Longint;
 LHour  : Longint;
 Y      : Word;
begin
 with DT do
  begin
   L     := 0;
   LHour := Hour;
   for Y := 1970 to Year - 1 do
    begin
     if (Y MOD 4 = 0) and (Y MOD 400 <> 0)
      then L := L + LeapYearSecs
      else L := L + NormYearSecs;
    end;
   for Y := 1 to Month - 1 do
    case Y of
      1 : L := L + (31 * SecsInDay);
      2 : if (Year MOD 4 = 0) and (Year MOD 400 <> 0)
           then L := L + (29 * SecsInDay)
           else L := L + (28 * SecsInDay);
      3 : L := L + (31 * SecsInDay);
      4 : L := L + (30 * SecsInDay);
      5 : L := L + (31 * SecsInDay);
      6 : L := L + (30 * SecsInDay);
      7 : L := L + (31 * SecsInDay);
      8 : L := L + (31 * SecsInDay);
      9 : L := L + (30 * SecsInDay);
     10 : L := L + (31 * SecsInDay);
     11 : L := L + (30 * SecsInDay);
     12 : L := L + (31 * SecsInDay);
    end; { case }
   L := L + (Day - 1) * SecsInDay;
   L := L + (LHour * 3600) + (Min * 60) + Sec;
   DateToLongint := L;
  end; { with }
end; { DateToLongint }

{--------------------
  The LongintToDate procedure converts a longint
  whose value is the number of seconds that have
  elapsed since January 1, 1970 to a DateTime record.
---------------------}
procedure LongintToDate(LDate : Longint; var DT : DateTime);
var
 L : Longint;

 function SecondsInYear(Y : Word) : Longint;
 begin
  if LeapYear(Y)
   then SecondsInYear := LeapYearSecs
   else SecondsInYear := NormYearSecs;
 end; { SecondsInYear }

 function SecondsInMonth(M : Word; Y : Word) : Longint;
 begin
  case M of
    1 : SecondsInMonth := 31 * SecsInDay;
    2 : if LeapYear(Y)
        then SecondsInMonth := 29 * SecsInDay
        else SecondsInMonth := 28 * SecsInDay;
    3 : SecondsInMonth := 31 * SecsInDay;
    4 : SecondsInMonth := 30 * SecsInDay;
    5 : SecondsInMonth := 31 * SecsInDay;
    6 : SecondsInMonth := 30 * SecsInDay;
    7 : SecondsInMonth := 31 * SecsInDay;
    8 : SecondsInMonth := 31 * SecsInDay;
    9 : SecondsInMonth := 30 * SecsInDay;
   10 : SecondsInMonth := 31 * SecsInDay;
   11 : SecondsInMonth := 30 * SecsInDay;
   12 : SecondsInMonth := 31 * SecsInDay;
  end; { case }
 end; { SecondsInMonth }

begin
 with DT do
  begin
   Year  := 1970;
   Month := 1;
   Day   := 1;
   Hour  := 0;
   Min   := 0;
   Sec   := 0;
   L := LDate;
   while L >= SecondsInYear(Year) do
    begin
     L := L - SecondsInYear(Year);
     Inc(Year);
    end; { while }

   while L >= SecondsInMonth(Month, Year) do
    begin
     L := L - SecondsInMonth(Month, Year);
     Inc(Month);
    end; { while }

   while L >= SecsInDay do
    begin
     L := L - SecsInDay;
     Inc(Day);
    end; { while }

   while L >= 3600 do
    begin
     L := L - 3600;
     Inc(Hour);
    end; { with }

   while L >= 60 do
    begin
     L := L - 60;
     Inc(Min);
    end; { with }

   Sec := L;
  end; { with }
end; { LongintToDate }

{--------------------
  The Now function reads the DOS system date and
  time and creates a longint whose value is the number
  of seconds that have elapsed since January 1, 1970.
---------------------}
function Now : Longint;
var
 DT     : DateTime;
 Dummy  : Word;
begin
 with DT do
  begin
   GetDate(Year, Month, Day, Dummy);
   GetTime(Hour, Min, Sec, Dummy);
   Now := DateToLongint(DT);
  end; { with }
end; { Now }

{--------------------
  The LeapYear function returns True if
  the year specified is a leap year.
---------------------}
function LeapYear(Year : Word) : Boolean;
begin
 LeapYear := (Year mod 4 = 0) and (Year mod 400 <> 0);
end; { LeapYear }

end.  { unit Utils }