{ SCOLLECT.PAS }
{
Description:    A collection object for Pascal-type strings.

Author:         Don Taylor
Date:           23 Feb 93
Last revised:   3 September 1994 19:15
Application:    IBM PC and compatibles; BP7.0; TV2.0
Copyright 1993, Don Taylor | All rights reserved
}

unit SCollect;

{--------------------}
      INTERFACE
{--------------------}

uses
 Objects,
 Strings;

type
 { Collection of Pascal-style strings }
 PPStrCollection = ^TPStrCollection;
 TPStrCollection = object(TCollection)
  constructor Init(ALimit, ADelta : Integer);
  function GetItem(var S : TStream) : Pointer; virtual;
  procedure PutItem(var S : TStream; Item : Pointer); virtual;
  procedure FreeItem(Item : Pointer); virtual;
 end; { object }

procedure RegisterCollections;

const
 RPStrCollection : TStreamRec = (
  ObjType : 102;
  VmtLink : Ofs(TypeOf(TPStrCollection)^);
  Load : @TPStrCollection.Load;
  Store : @TPStrCollection.Store
 );

{--------------------}
   IMPLEMENTATION
{--------------------}

{-------------------------}
{     Global Routines     }
{-------------------------}

{---------------------
  RegisterCollections registers the
  objects for this unit.
----------------------}
procedure RegisterCollections;
begin
 RegisterType(RPStrCollection);
end; { RegisterCollections }


{-------------------------}
{ TPStrCollection Methods }
{-------------------------}

{---------------------
  Init constructs a TPStrCollection object.
----------------------}
constructor TPStrCollection.Init(ALimit, ADelta : Integer);
begin
 inherited Init(ALimit, ADelta);
end; { TPStrCollection.Init }

{---------------------
  FreeItem releases the heap memory occupied by
  a Pascal string.
----------------------}
procedure TPStrCollection.FreeItem(Item : Pointer);
begin
 if Item <> nil then DisposeStr(Item);
end; { TPStrCollecton.FreeItem }

{---------------------
  GetItem reads a Pascal string from a stream.
----------------------}
function TPStrCollection.GetItem(var S : TStream) : Pointer;
var
 PStr : String;
 len  : Word;
begin
 S.Read(len, 2);
 S.Read(PStr, len);
 GetItem := NewStr(PStr);
end; { TPStrCollection.GetItem }

{---------------------
  PutItem writes a Pascal string to a stream.
----------------------}
procedure TPStrCollection.PutItem(var S : TStream; Item : Pointer);
var
 len  : Word;
 code : Integer;
begin
 Val(String(Item^)[0], len, code);
 S.Write(len, 2);
 S.Write(Item^, len);
end; { TPStrCollection.PutItem }

end. { Unit SCollection }


