; Penttest.asm - test a Pentium CPU for incorrect division
;   using numbers known to cause errors in division
         MASM
         .MODEL  small

BIOSSeg  SEGMENT AT 40H          ; BIOS Data Area
         ENDS

        .DATA
Devices  EQU     10H            ; Offset of Devices Present Word
                                ;  in BIOS Data Area (40H:10H)
MCPMask  EQU     0002H          ; Mask for Coprocessor Present
                                ;  (Bit 1) in BIOS Data Area
num1     DD      4195835
num2     DD      3145727
BadCPU   DB     'This Pentium CPU performs division incorrectly.'
         DB      0aH, 0dH
BadCPULen   EQU  $ - BadCPU
OKCPU    DB     'This CPU performs division correctly.', 0aH, 0dH
OKCPULen EQU     $ - OKCPU
NoMCP    DB     'No math coprocessor was found.'
         DB      0aH, 0dH
NoMCPLen EQU     $ - NoMCP

        .STACK  64

        .CODE
        .386
        .387
Start   PROC    NEAR
        mov     ax, @data
        mov     ds, ax
        assume  ds:@data
        mov     ax, BIOSSeg
        mov     es, ax
        assume  es:BIOSSeg
        mov     ax, [es:Devices]; Get installed devices
                                ;  from BIOS Data Area
        and     ax, MCPMask     ; Bit 1 set if coprocessor present
        jnz     Continue        ; Coprocessor was found

; No coprocessor was found, so display message then exit
        mov     ah, 40h         ; DOS Write to File or Device
        mov     bx, 1           ; Handle of Stdout
        mov     dx, offset NoMCP
        mov     cx, NoMCPLen
        int     21h
        jmp     Exit


; A coprocessor was found -- test it for correct division
Continue:
        finit
        fild    num1
        fild    num2
        fld     st
        fild    num1            ; TOS -> num1, num2, num2, num1
        fdivrp  st(1)           ; TOS -> num1/ num2, num2, num1
        fmulp   st(1), st       ; TOS -> num1/num2 * num2, num1
        fsubp   st(1), st       ; Result is 0 if division correct
        fldz                    ; Load 0.0
        fcompp   st(1)
        pushf                   ; Save flags register
        fstsw   ax              ; Store status word in AX
        sahf                    ; Store AH in flags register
        mov     ah, 40h         ; Get set to display a message
        mov     bx, 1           ;   to Stdout
        je      OK              ; Jump if no error


; Division was incorrect, so display a message and exit
        mov     dx, offset BadCPU
        mov     cx, BadCPULen
        int     21h
        jmp     Done


; Division was correct, so display a message and exit

OK:     mov     dx, offset OKCPU
        mov     cx, OKCPULen
        int     21h
Done:   popf                    ; Restore old flags value
Exit:   mov     ax, 4c00h       ; Return to DOS
        int     21h
Start   ENDP
        END
