;
; Typical Bresenham's line drawing inner loop, using code
; patching to set the drawing color.
;
; Input to function:
;       AL = drawing color
;       <other drawing parameters here>
DrawLine proc   near
        mov     byte ptr cs:[PatchMarker-1],al
                                ;set the drawing color by
                                ; filling in the constant
                                ; field in the MOV that
                                ; draws pixels

; <set up for PixelLoop here>

;
; Input:
;       EAX = error term at first pixel (x1,y1)
;       EBX = base error term advance
;       ECX = number of pixels to draw - 1
;       EDX = error term adjust when error term turns over
;       ESI = ptr adjust when error term turns over
;       EDI = pointer to first pixel (x1,y1)
;       EBP = base (no error term turnover) ptr advance
;       First pixel in line already drawn.
;
PixelLoop:
        add     eax,ebx         ;advance error term
        jnc     short NoTurnOver ;see if it turned over
        add     edi,esi         ;turned over; advance screen
        add     eax,edx         ; ptr and adjust error term
NoTurnOver:
        add     edi,ebp         ;base advance for screen ptr
                                ;AGI on 486 and Pentium
        mov     byte ptr [edi],0 ;draw the pixel (value
                                 ; patched to correct color
                                 ; before loop is started)
PatchMarker:
        dec     ecx             ;count off pixels
        jnz     PixelLoop


