;
; Nicholas Fullagar's branch-free Bresenham's line drawing
; inner loop, rearranged to improve 486 and Pentium
; pipelining.
;
; Input:
;       EAX = error term #2 (error term at fourth pixel)
;       BL  = line color
;       ECX = -1 if error term turns over on initial run
;               from first pixel to third pixel, 0 else
;       EDX = -1 if error term turns over on initial run
;               from second pixel to fourth pixel, 0 else
;       ESI = screen ptr #1 (ptr to first pixel in line)
;       EDI = screen ptr #2 (ptr to second pixel in line)
;       EBP = error term #1 (error term at third pixel)
;       addPtr[0] = 2X screen pointer advance amount
;               when error term turns over
;       addPtr[1] = 2X screen pointer advance amount
;               when error term doesn't turn over
;       addErr[0] = 2X error term advance amount when
;               error term turns over
;       addErr[1] = 2X error term advance amount when
;               error term doesn't turn over
;       First pixel in line NOT already drawn.
;

;---start of unrolled code for two pixels---

        add     edi,addPtr[edx*4+4] ;advance screen ptr #1
        add     eax,addErr[edx*4+4] ;advance error term
        sbb     edx,edx             ;0 if error term
                                    ; didn't turn over
                                    ; time it advanced,
                                    ; -1 if it turned
                                    ; over
EnterLoopHere:
        mov     [esi],bl            ;draw pixel
        add     esi,addPtr[ecx*4+4] ;advance screen ptr #2
        add     ebp,addErr[ecx*4+4] ;advance error term
        sbb     ecx,ecx             ;0 if error term
                                    ; turned over,
                                    ; 1 if it turned
                                    ; over
        mov     [edi],bl            ;draw pixel

;---end of unrolled code for two pixels---

