7 #                                                       $    $  $    $    $   2   D    D    D    D 
  N 
  X    X   x  D    z        *      $                                                  ;
 ; Nicholas Fullagar's branch-free Bresenham's line drawing
 ; inner loop, rearranged to improve 486 and Pentium
 ; pipelining.
 ;
 ; Input:
 ;       EAX = error term at second pixel
 ;       BL  = line color
 ;       ECX = number of pixels to draw
 ;       EDI = pointer to first pixel (x1,y1)
 ;       CF  = 1 if error term turns over between first
 ;               and second pixels, 0 else
 ;       addPtr[0] = EDI (screen pointer) advance amount
 ;               when error term turns over
 ;       addPtr[1] = EDI (screen pointer) advance amount
 ;               when error term doesn't turn over
 ;       addErr[0] = EAX (error term) advance amount when
 ;               error term turns over
 ;       addErr[1] = EAX (error term) advance amount when
 ;               error term doesn't turn over
 ;       First pixel in line NOT already drawn.
 ;
 PixelLoop:
         sbb     edx,edx                 ;0 if error term
                                         ; didn't turn over,
                                         ; -1 if it turned
                                         ; over (CF status
                                         ; from ADD EAX)
                                         ;AGI on Pentium
         mov     [edi],bl                ;draw pixel
         add     edi,addPtr[edx*4+4]     ;advance screen ptr
         add     eax,addErr[edx*4+4]     ;advance error term
         dec     ecx                     ;count off pixels
                                         ;******************
                                         ;* doesn't affect *
                                         ;* Carry flag     *
                                         ;******************
         jnz     PixelLoop
 
         mov     [edi],bl                ;draw last pixel
 
 
  u dd     edi,addPtr[edx*4+4]     ;advance screen ptr
         add     eax,addErr[edx*4+4]     ;advance error term
         dec     ecx                     ;count off pixels
                                         ;******************
                                         ;* doesn't affect *
                                         ;* Carry flag     *
                                         ;******************
         jnz     PixelLoop
 
         mov     [edi],bl                ;draw last pixel
 
 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
 @      
 :F           >  s              )  a        *  ]        &  V  Y  e        R        6  s      (  e                                                                                                                                                                                                                                                                                                              !  *               
                                                 
         ! "                            x(){"""""!"$"1"2"3"4"6"7"="D"E"G"R"S"Z"""""""""""""""""""""""""""""""""""""""""""""# #########****3-3.3U3V3W3X3Y3Z3[3\333333333333333333888888999999/90919298999:9;9O9P9Q9R9S9T9U9V9W9X9Y9Z999999999999999999999999999999999999999999999:::	:
:::
::::::::::::::::::: :!:":#:$:%:&:0:1:2:5:6:7:8:9:::E:F:G:H:I:J:K:L:O:P:Q:Y:Z:e:f:g:h:i:j:k:l:u:v:w:x:y:z:{:|:::::::::::::::    H H    (EG(    H H    (    d       '                     @                         =/  R          H -:LaserWriter 8.0 
           :FB Letter Gothic Bold   `  ` 	    `     ( e ( B    Cool Barbara  Cool Barbara                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  