;
; Typical Bresenham's line drawing inner loop, rearranged
; to improve Pentium pipelining.
;
; Input:
;       EAX = error term at first pixel (x1,y1)
;       EBX = base error term advance
;       ECX = number of pixels to draw
;       EDX = error term adjust when error term turns over
;       ESI = ptr adjust when error term turns over
;       EDI = pointer to first pixel (x1,y1)
;       EBP = base (no error term turnover) ptr advance
;       First pixel in line NOT already drawn.
;
PixelLoop:
        mov     byte ptr [edi],PIX_VALUE ;draw the pixel
        add     edi,ebp         ;base advance for screen ptr
        add     eax,ebx         ;advance error term
        jnc     short NoTurnOver ;see if it turned over
        add     edi,esi         ;turned over; advance screen
        add     eax,edx         ; ptr and adjust error term
NoTurnOver:
        dec     ecx             ;count off pixels
        jnz     PixelLoop

        mov     byte ptr [edi],PIX_VALUE ;draw last pixel

