;
; Typical Bresenham's line drawing inner loop, rearranged
; to improve 486 and Pentium pipelining.
;
; Input:
;       EAX = error term at first pixel (x1,y1)
;       EBX = base error term advance
;       ECX = number of pixels to draw - 1
;       EDX = error term adjust when error term turns over
;       ESI = ptr adjust when error term turns over
;       EDI = pointer to first pixel (x1,y1)
;       EBP = base (no error term turnover) ptr advance
;       First pixel in line already drawn.
;
PixelLoop:
        add     eax,ebx         ;advance error term
        jnc     short NoTurnOver ;see if it turned over
        add     edi,esi         ;turned over; advance screen
        add     eax,edx         ; ptr and adjust error term
NoTurnOver:
        add     edi,ebp         ;base advance for screen ptr
        dec     ecx             ;count off pixels
                                ;AGI on Pentium
        mov     byte ptr [edi],PIX_VALUE ;draw the pixel
        jnz     PixelLoop

