;
; Nicholas Fullagar's branch-free Bresenham's line drawing
; inner loop.
;
; Input:
;       EAX = error term at second pixel
;       BL  = line color
;       ECX = number of pixels to draw - 1
;       EDI = pointer to first pixel (x1,y1)
;       CF  = 1 if error term turns over between first
;               and second pixels, 0 else
;       addPtr[0] = EDI (screen pointer) advance amount
;               when error term turns over
;       addPtr[1] = EDI (screen pointer) advance amount
;               when error term doesn't turn over
;       addErr[0] = EAX (error term) advance amount when
;               error term turns over
;       addErr[1] = EAX (error term) advance amount when
;               error term doesn't turn over
;       First pixel in line already drawn.
;
PixelLoop:
        sbb     edx,edx                 ;0 if error term
                                        ; didn't turn over,
                                        ; -1 if it turned
                                        ; over (CF status
                                        ; from ADD EAX)
                                        ;AGI on Pentium
        add     edi,addPtr[edx*4+4]     ;advance screen ptr
        add     eax,addErr[edx*4+4]     ;advance error term
                                        ;AGI on Pentium
        mov     [edi],bl                ;draw pixel
        dec     ecx                     ;count off pixels
                                        ;******************
                                        ;* doesn't affect *
                                        ;* Carry flag     *
                                        ;******************
        jnz     PixelLoop

