#include <dir.h>
#include <dos.h>
#include <stdio.h>

/* Returns 1 if drive is ready, 0 if not;  drive 0=A, 1=B, etc. */

int test_drive( int drive )
 {
 int rtn;
 static char currdir[MAXDIR+1] = "\\";  /* current dir   */
 static char rootdir[] = " :\\";        /* test drv root */

 getcurdir( 0, &currdir[1] );
 /* try to change to root directory of test drive */
 rootdir[0] = drive + 'A';
 rtn = (chdir( rootdir ) == 0);
 chdir( currdir );
 return( rtn );
 }

/* Suppress DOS message, but let chdir() flag error. */

#pragma warn -rvl
int critical_error( void )
 {
 hardretn( 0 );
 }
#pragma war .rvl

void main( void )
 {
 int           i,                /* drive #              */
               d_max;            /* max drives           */
 unsigned char d_logic = 0;      /* logical drives A/B   */
 union REGS    regs;

 harderr( critical_error );
 d_max = setdisk( getdisk() );
 for ( i = 0 ; i < d_max ; i++ )
  {
  regs.x.ax = 0x440E;            /* use IOCTL func 0Eh   */
  regs.h.bl = i + 1;             /* to check drive i map */
  int86( 0x21, &regs, &regs );
  if
   (
   !regs.x.cflag                 /* IOCTL call ok        */
   &&
   regs.h.al                     /* more than one drive  */
   &&
   regs.h.al != regs.h.bl        /* drive != device      */
   )
   {
   regs.x.ax = 0x440F;           /* use IOCTL func 0Fh   */
   regs.h.bl = i + 1;            /* map drive to device  */
   int86( 0x21, &regs, &regs );
   }
  if ( !d_logic )                /* save logical A:      */
   d_logic = regs.h.al;
  printf
   (
   "Drive %c:  %sready\n"
   , i + 'A'
   , test_drive(i) ? "" : "not "
   );
  }
 if ( d_logic )
  {
  regs.x.ax = 0x440F;            /* reset A:             */
  regs.h.bl = d_logic;
  int86( 0x21, &regs, &regs );
  }
 }
