unit StackMin;
{$IFDEF MSDOS}
  This unit compiles only in DPMI and Windows modes
{$ENDIF MSDOS}

{$IFNDEF VER70}
   {$IFNDEF WINDOWS}
     This units compiles only in Borland Pascal 7.0 or Turbo Pascal for Windows
   {$ENDIF WINDOWS}
{$ENDIF VER70}

interface
  function StackSize:  word;
  function StackUsage: word;

implementation

  Type
    PInstanceData = ^TInstanceData;
    TInstanceData = record   { ofs description }
      wNull:        word;    { $00 always zero }
      pSSSP:        pointer; { $02 default 5 - temporary SSPSP storage for SwitchStackTo }
      pLocalHeap:   word;    { $06 not used in DPMI }
      pAtomTable:   word;    { $08 not used in DPMI }
      pStackTop:    word;    { $0A near pointer to stack top }
      pStackMin:    word;    { $0C near pointer to stack low water mark }
      pStackBottom: word;    { $0E near pointer to stack bottom }
                             { stack grows from top to bottom }
    end;

const
  InstanceData: PInstanceData = nil;

  function StackSize:  word;
  begin
    StackSize := InstanceData^.pStackTop - InstanceData^.pStackBottom;
  end;

  function StackUsage: word;
  begin
    StackUsage := InstanceData^.pStackTop - InstanceData^.pStackMin;
  end;

begin
  InstanceData := Ptr(SSeg, 0);
end.

