// SPHERE.C -- Include in BITMANIP.C

#define TITLE "Projection onto a Sphere"
#include <math.h>
#define EPSILON (0.0000001)

unsigned long ComputePixel(int x, int y){
  double xmid, ymid, xx, yy, delta, dist, factor;

  // Rescale x and y to measure from center, not corner
  xmid = (NewHeader->width - 1)/2.0;   xx = x - xmid;
  ymid = (NewHeader->height - 1)/2.0;  yy = y - ymid;

  // Compute distance from center, map onto range 0..1
  delta = xx*xx + yy*yy;
  if (delta < EPSILON)       // avoid sqrt of approximate zero
     dist = 0.0;
  else
     dist = 1.01 * sqrt(delta) / min(xmid,ymid);

  // Compute scaling factor using arcsine function
  if (dist > 1.0)
    return(0L);              // out of range
  else if (dist < EPSILON)
    factor = 1.0/1.57;       // avoid dividing by 0
  else
    factor = asin(dist) / (dist * 1.57);

  // Apply scaling transformation
  xx = xx * factor;     yy = yy * factor;

  // Back to original coordinate system
  x = xx + xmid;        y = yy + ymid;

  // Pick a pixel from the computed location, and return its value
  return ReadPixel(x,y);
}
