/*************************************************************************
   ADDATTR.H

   C-callable routine that adds video attributes to a text buffer,
   to prepare the buffer to be moved directly into video memory.
   May be used with any memory model.

   AddAttr() works by transferring characters from SrcBuf to
   DestBuf, along with an attribute byte from AttrList.  Each
   time it encounters an embedded Flag character in SrcBuf,
   AddAttr() gets the next attribute byte from AttrList.
   For example:

   static char *NewMenu;
   static char Menu[] =
      {
      "Menu of Choices"
      "~F~irst Choice "                Flag is '~' (ASCII 126)
      "~S~econd Choice"
      "~T~hird Choice "
      };
   static char MenuAttr[] = { 15, 7, 15, 7, 15, 7 };
   NewMenu = (char *)malloc( sizeof(Menu) * 2 );
   AddAttr( NewMenu, Menu, MenuAttr, sizeof(MenuAttr), 7, '~' );

   AddAttr() moves each character in the first line of Menu to
   NewMenu, along with an attribute byte of 7, since that is the
   default attribute passed to it in the call.  Next, AddAttr()
   encounters a '~', so it picks up the first attribute byte (15)
   from MenuAttr, and stores it in NewMenu along with 'F'.  When
   AddAttr() encounters the second '~' character, it picks up the
   second attribute byte (7) and stores it, along with each of the
   remaining characters in the second line, in NewMenu.  AddAttr()
   continues in this manner for the rest of Menu.  When it has
   finished with Menu, NewMenu will be ready to move into video
   memory with a routine such as puttext().

   If MenuAttr contains fewer attribute bytes than the number of
   Flag characters in Menu, AddAttr() uses the last byte from
   MenuAttr for the remainder of Menu.  If MenuAttr is null, or
   if no flag characters occur in Menu, AddAttr() uses the
   default attribute passed in Attr.

   Since AddAttr() requires three far pointers to char and
   only two can be set up at any one time using DS and ES,
   AttrList and SrcBuf MUST be in the same data segment.
   That should not be a problem, since the string in SrcBuf
   and the attribute list that applies to it will most likely
   be defined in the same module.
*************************************************************************/

void pascal far AddAttr
               (
               char far *  DestBuf,    /* receiving buffer              */
               char far *  SrcBuf,     /* text buffer                   */
               char far *  AttrList,   /* list of attribute bytes       */
               int         ListSize,   /* length of AttrList            */
               int         Attr,       /* default attribute             */
               int         Flag        /* mark attribute changes        */
               );

/**** EOF:  ADDATTR.H ****/

