;===============================================================
; ADDATTR.ASM
;
; C-callable routine for preparing text to be moved directly
; into video memory.  Works under any memory model.
;
;    Assembler:     Turbo Assembler 1.0
;                   tasm /ml/t/w2/z addattr;
;  C prototype:
; void pascal far addattr
;             (
;      char far     *DestBuf,    /* receiving buffer          */
;      char far     *SrcBuf,     /* text array                */
;      char far     *AttrList,   /* list of attribute bytes   */
;           int      ListSize,   /* length of AttrList        */
;           int      Attr,       /* default attribute         */
;           int      Flag        /* mark attribute changes    */
;             )     ;
;
;       Author:     Richard Zigler
;         Date:     August, 1994
;===============================================================

         .model     small, pascal
          .code

         public     ADDATTR
        ADDATTR     proc far
           uses     si, di, ds

            arg     Flag      :word          ;mark attr changes
            arg     Attr      :word          ;default attribute
            arg     ListSize  :word          ;length of AttrList
            arg     AttrList  :far ptr byte  ;list of attributes
            arg     SrcBuf    :far ptr byte  ;text array
            arg     DestBuf   :far ptr byte  ;receiving buffer

            cld
            mov     cx, [ListSize]
            les     di, [DestBuf]

; For this next to work, AttrList and SrcBuf
; must be in the same segment.

            lds     bx, [AttrList]
            lds     si, [SrcBuf]
            mov     dl, byte ptr [Flag]
            mov     ah, byte ptr [Attr]
           jcxz     NoAttr              ;if no AttrList
            and     dl, dl
             jz     NoAttr              ;if no flag char
GetChar:
          lodsb
            and     al, al
             jz     Exit                ;if end of SrcBuf
            cmp     al, dl
             je     GotFlag
          stosw                         ;char/attr ==> DestBuf
            jmp     GetChar
GotFlag:
          lodsb                         ;get next char
            mov     ah, [bx]            ; and next attr byte
          stosw
            inc     bx
           loop     GetChar             ;if at end of AttrList,
NoAttr:                                 ; fall through
          lodsb
            and     al, al
             jz     Exit
          stosw
            jmp     NoAttr
Exit:
            ret                         ;else done
        ADDATTR     endp
            end

; EOF:  ADDATTR.ASM

