/* Chicago Jigsaw -- Williams */
#include <windows.h>
#include <commctrl.h>
#include "jigsaw.h"

/* Block/grid size */
#define IMAGESIZEX 80
#define IMAGESIZEY 100

/* Handle to main window */
HWND       hWnd;
/* Handle to instance data*/
HINSTANCE  hInst;

LRESULT CALLBACK MainWndProc();

int PASCAL WinMain(HINSTANCE hInstance,
  HINSTANCE hPrevInstance,LPSTR lpCmdLine,
  int nCmdShow)
  {
  MSG msg;
  InitCommonControls(); /* Set up */
  if (!hPrevInstance)
    if (!InitApplication(hInstance))
       return (FALSE);
  if (!InitInstance(hInstance, nCmdShow))
       return (FALSE);
  while (GetMessage(&msg, 0, 0, 0))
    {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }
  return (msg.wParam);
  }

/* Register class */
BOOL InitApplication(HINSTANCE hInstance)
   {
   WNDCLASS wc;
   wc.style = 0;
   wc.lpfnWndProc = (WNDPROC)MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(hInstance, "ICON1");
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE+1);
   wc.lpszMenuName ="MainMenu";
   wc.lpszClassName = "MainPClass";
   return (RegisterClass(&wc));
   }

/* Create window */
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
   {
   hInst = hInstance;
   hWnd = CreateWindow(
       "MainPClass",
       "Image List Jigsaw",
       WS_OVERLAPPEDWINDOW,
       CW_USEDEFAULT,CW_USEDEFAULT,
       640,400,
       NULL,NULL,hInstance,NULL);
   if (!hWnd)
       return (FALSE);
   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);
   return (TRUE);
   }

/* Scramble up blocks -- you can do better! */
void scramble(POINT *pos,int len)
  {
  int i,j;
  for (j=0,i=len-1;i>=0;i--,j++)
    {
/* Make sure blocks snap to grid */
    pos[i].x=(j%4)*2*IMAGESIZEX;
    pos[i].y=(j/4)?IMAGESIZEY*2:0;
    }
  }

LRESULT CALLBACK  MainWndProc(HWND hWnd,
  UINT message, WPARAM wParam, LPARAM lParam)
   {
   static HIMAGELIST il;  /* images */
   static POINT pos[8],hot;  /* position & hotspot */
   static int drag=0;    /* dragging which block 0=none */
   static POINT ptz;     /* window/client offset */
   switch (message)
     {
     case WM_CREATE:
         il=ImageList_LoadBitmap(hInst,
           "BITMAPSTRIP",IMAGESIZEX,1,CLR_NONE);
         scramble(pos,sizeof(pos)/sizeof(pos[0]));
         break;

     case WM_LBUTTONDOWN:
         {
         int i;
         POINT mp;
         mp.x=LOWORD(lParam);  /* Set point */
         mp.y=HIWORD(lParam);
/* Test for hit */
         for (i=0;i<sizeof(pos);i++)
           {
           if (pos[i].x<=mp.x&&pos[i].x+IMAGESIZEX>mp.x)
             if (pos[i].y<=mp.y&&pos[i].y+IMAGESIZEY>mp.y)
               {
/* hit! */
               RECT wrect;
               drag=i+1;  // set drag flag
               ptz.x=ptz.y=0;
               hot.x=mp.x-pos[i].x;  // compute hot spot
               hot.y=mp.y-pos[i].y;
               ShowCursor(FALSE);   // cursor off
               SetCapture(hWnd);    // capture
/* Compute offset */
               GetWindowRect(hWnd,&wrect);
               ClientToScreen(hWnd,&ptz);
               ptz.x-=wrect.left;
               ptz.y-=wrect.top;
               ImageList_StartDrag(il,hWnd,drag-1,mp.x
                +ptz.x,mp.y+ptz.y,hot.x,hot.y);
               ImageList_DragShow(TRUE);
               break;
               }
           }
         }
         break;

     case WM_MOUSEMOVE:
         if (drag)
           ImageList_DragMove(LOWORD(lParam)+ptz.x,
             HIWORD(lParam)+ptz.y);
         break;

     case WM_LBUTTONUP:
         if (drag)
           {
           RECT r;
           POINT p;
           ImageList_EndDrag();
           ReleaseCapture();
           ShowCursor(TRUE);
           GetClientRect(hWnd,&r);
/* Snap point to nearest grid position
   -- ought to prevent overlaying, too but I don't */
           p.x=((LOWORD(lParam)-hot.x+
             IMAGESIZEX/2)/IMAGESIZEX)*IMAGESIZEX;
           p.y=((HIWORD(lParam)-hot.y+
             IMAGESIZEY/2)/IMAGESIZEY)*IMAGESIZEY;
           if (PtInRect(&r,p))  /* in client area? */
             pos[drag-1]=p;
           drag=0;
           InvalidateRect(hWnd,NULL,TRUE);
           }
         break;


     case WM_COMMAND:
           switch (wParam)
             {
             case IDM_EXIT:
                DestroyWindow(hWnd);
                break;

             case IDM_CHG:
                {
                static int pix=0;
                ImageList_Destroy(il);
                il=ImageList_LoadBitmap(hInst,
                   pix?"BITMAPSTRIP":"MAPBITMAP",
                   IMAGESIZEX,1,CLR_NONE);
                pix^=1;
                }
/* Fall into scramble... */

             case IDM_SCRAM:
                scramble(pos,sizeof(pos)/sizeof(pos[0]));
                InvalidateRect(hWnd,NULL,TRUE);
                break;

             case IDM_ABOUT:
                MessageBox(hWnd,
                  "Image List Jigsaw by Al Williams",
                  "About",MB_OK|MB_ICONEXCLAMATION);
                break;
             }
         break;

       case WM_PAINT:
         {
         HDC dc;
         PAINTSTRUCT ps;
         int i;
         dc=BeginPaint(hWnd,&ps);
/* Draw all images */
         for (i=0;i<sizeof(pos);i++)
           ImageList_Draw(il,i,dc,pos[i].x,
             pos[i].y,ILD_NORMAL);
         EndPaint(hWnd,&ps);
         return 0;
         }

       case WM_DESTROY:
           ImageList_Destroy(il);
           PostQuitMessage(0);
           break;

       default:
           return (DefWindowProc(hWnd, message,
             wParam, lParam));
       }
     return 0;
  }


