{= Virtual Constructors & Class Reference Variables =}

type
  TBase = class
    constructor Create; virtual;
    . . .
  end;

  TDescendant = class( TBase )
    constructor Create; override;
    . . .
  end;

  TSample = class( TBase )
    constructor Create; override;
    . . .
  end;

  TBaseClass = class of TBase;           { Class Reference Type }

var
  ClassRef : TBaseClass;             { Class Reference Variable }
  BaseObj  : TBase;                  { Object Instance Variable }

begin
  ClassRef := TSample;        { Point ClassRef to TSample Class }
  BaseObj := ClassRef.Create;   { Polymorphically create object }
end;  
