  Function IsEnhanced : Boolean;
  Var
    StateFrom16 : Byte;
    ShiftState : ^Byte;
  Begin
    IsEnhanced := False;
    ShiftState := Ptr (Seg0400, $0017);
    asm
      mov ah,12h
      int 16h      { get shift state in AL }
      mov StateFrom16,al
    End;
    If StateFrom16 <> ShiftState^ Then Exit;
    ShiftState^ := ShiftState^ xor $20;
    asm
      mov ah,12h
      int 16h
      mov StateFrom16,al
    END;
    IsEnhanced := StateFrom16 = ShiftState;
    ShiftState^ := ShiftState^ xor $20;
  END;

  Function SetKeyboardMode (Mode : Byte) : Byte;
  Begin
    If Mode <> KeyboardMode Then
      If Mode = kbmStandard Then
        KeyboardMode := Mode
      Else If (Mode = kbmExtended) and (IsEnhanced) Then
        KeyboardMode := Mode;
    SetKeyboardMode := KeyboardMode;
  End;
