{= Demonstration of Overriding Methods =}

type
  TBase = class
    procedure VirtualProc; virtual;
    procedure DynamicProc; dynamic;
  end;

  TDescendant = class( TBase )
    procedure VirtualProc; override;
    procedure DynamicProc; override;
  end;

procedure TBase.VirtualProc;
begin
  MessageDlg( TBase Class, mtInformation, [ mbOk ], 0 );
end;

procedure TDescendant.VirtualProc;
begin
  inherited VirtualProc;
  MessageDlg( TDescendant Class, mtInformation, [ mbOk ], 0 );
end;


{= Elsewhere in the Program =}

procedure Test( P : TBase );
begin
  P.VirtualProc;
end;


var
  BaseObj : TBase;
  DescObj  : TDescendant;

begin
  BaseObj := TBase.Create;
  DescObj := TDescendant.Create;

  Test( BaseObj );
  Test( DescObj );
end.
