;Copyright (c) 1994 by Chrysalis Software Corporation.
;All rights reserved.
;Licensed for personal use only; for commercial use, please contact
;Chrysalis Software Corporation, P.O. Box 0335, Baldwin, NY 11510.

;/*TITLE a token-threaded interpreter for the i386 and above
;****keyword-flag*** "%v %f %n"
; "14 13-Aug-94,16:47:02 INTERP.ASM"


;NOTE: This version of the interpreter executes the p-code 1000
;times, to give the profiler something to work with.  To run a
;program once, you can get rid of the timing loop by changing
;the "outer_count" value to 1.

.386
model small

next            macro
		mov     bl,[si] ;get next opcode byte
		inc     si              ;and bump IP
		jmp     address_table[ebx*2];jump through table entry
		endm
	
Code_Seg        segment use16

		assume  CS:Code_Seg
		assume  DS:Data_Seg

Start   proc near
		mov     ax,Data_Seg
		mov     ds,ax

		mov     outer_count, 1000 ;change this to 1 to run once

TimingLoop      equ     $

		lea     si,interp_code
		xor     ebx,ebx         ;clear high part of offset
		call    StartRun
		dec     outer_count
		jne     TimingLoop

		mov     ah,4ch
		int     21h
		ret
Start   endp

StartRun        proc    near
		next
StartRun        endp

align   4
qsumc   proc    near            ;sum a column or portion thereof
		mov     di,[si] ;get starting offset
		add     si,2            ;and bump IP

		mov     cx,[si] ;get element count
		add     si,2            ;and bump IP
		
		fldz                    ;clear TOS value
		jcxz    qsumc_lpe       ;if no elements, skip loop

qsumc_lp        equ     $               ;loop to calculate sum
		fadd    data_table[di]
		add     di,data_size
		dec     cx              ;count down
		jne     qsumc_lp        ;and continue if not done
qsumc_lpe       equ     $
		next
qsumc   endp

align   4
qpush   proc near       ;push spreadsheet entry onto TOS
		mov     di,[si] ;get data offset
		add     si,2            ;and bump IP
		fld     data_table[di]; move data to FPU
		next
qpush   endp

align   4
qadd            proc    near            ;add TOS and 2nd
		faddp st(1),st	;replacing them with the result
		next
qadd            endp

align   4
qmul            proc    near            ;multiply TOS and 2nd
		fmulp st(1),st  ;replacing them with the result
		next
qmul            endp

align   4
qdiv            proc    near            ;divide 2nd by TOS
		fdivp st(1),st  ;replacing them with the result
		next
qdiv            endp

align   4
qsub            proc    near            ;subtract TOS from 2nd
		fsubp st(1),st  ;replacing them with the result
		next
qsub            endp

align   4
qpushl  proc near               ;push literal value on TOS
		fld     qword ptr [si]          ;load double
		add     si,data_size;increment IP
		next
qpushl  endp

align   4
qpop    proc    near    ;pop entry from TOS into spreadsheet
		mov     di,[si] ;get data offset
		add     si,2            ;and bump IP
		fstp data_table[di]; move data from FPU
		next
qpop            endp

align   4
qdisplay        proc near               ;display result on screen
		push    ebx
		fmul    decimal_correction;
		fbstp display_value;
		lea     di,display_value+bcd_size;get address of value
		cmp     byte ptr -1[di], 80h    ;negative?
		jne     qdis_sign_ok;if not, skip
		mov     ah,02h
		mov     dl,'-'
		int     21h
qdis_sign_ok    equ     $
		mov     bx,bcd_size-1   ;number of bytes to display
		dec     di              ;skip sign byte
		xor     dh,dh   ;keep track of leading zero suppression
qdis_lp equ     $
		dec     di              ;point to next byte
		mov     dl,[di] ;get packed decimal byte
		mov     cl,4
		shr     dl,cl
		or      dh,dl   ;see if any non-zero bytes yet
		je      qdis_1  ;if leading zeroes, skip
		add     dl,'0'
		mov     ah,02h  ;DOS interrupt code
		int     21h             ;send it out
qdis_1  equ     $
		mov     dl,[di] ;get packed decimal byte
		and     dl,0fh  ;low digit only
		or      dh,dl   ;see if any non-zero bytes yet
		je      qdis_2  ;if leading zeroes, skip
		add     dl,'0'
		mov     ah,02h  ;DOS interrupt code
		int     21h             ;send it out
qdis_2  equ     $
		cmp     bx,2            ;ready for decimal point?
		jne     qdis_3  ;if not, forget it
		mov     ah,02h
		mov     dl,'.'
		int     21h
qdis_3  equ     $
		dec     bx
		jne     qdis_lp
		mov     ah,02h
		mov     dl,0dh
		int     21h
		mov     ah,02h
		mov     dl,0ah
		int     21h
		pop     ebx
		next
qdisplay        endp

align   4
qdiscard        proc near
		ffree   st      ;pop
		next
qdiscard        endp

align   4
qstop   proc near
		mov     al,0            ;return good status
		ret
qstop   endp
Code_Seg        ends


stack 200h    ;reserve stack space as needed for application

Data_Seg segment use16

;Here is a list of the register assignments for the 80x86 
;interpreter:
;AX:    scratch
;BL:    scratch
;EBX (except bl): 0
;CX:    scratch
;DX:    scratch
;SI:    IP
;DI:    scratch
;SP:    return stack

iqpush  equ     0       ;push spreadsheet entry onto TOS
iqadd   equ     1       ;add two top entries on stack
iqstop  equ     2       ;stop the interpreter
iqpushl equ     3       ;push literal value onto TOS
iqpop   equ     4       ;pop TOS into spreadsheet entry
iqdisplay       equ     5       ;display TOS on screen
iqmul   equ     6       ;multiply
iqdiv   equ     7       ;divide
iqsub   equ     8       ;subtract
iqdiscard       equ     9       ;discard value from TOS
iqsumc  equ     10      ;sum a column or portion thereof
iqlast  equ     iqsumc;highest value

col_count       equ     10      ;columns are A-J
row_count       equ     400     ;handles 30-year monthly mortgage

bcd_size        equ     10      ;number of bytes in BCD value

outer_count     dw      0

data_size               dw      8
data_shift      equ     3

row_count_word  dw      row_count
display_value   dt      0
decimal_correction dq   100.00
data_table      dq      col_count dup (row_count dup (0.0))
address_table   dw      qpush,qadd,qstop,qpushl,qpop,qdisplay
			dw      qmul,qdiv,qsub,qdiscard,qsumc
			dw      (255-iqlast) dup (0)

interp_code     equ     $

include interp.cod

		db      iqstop          ;stop the action

Data_Seg        ends

end             Start
